;-----------------------------------------------------------------------
; 2&1.ASM source for 2&1.EXE program: MASM 2&1, LINK 2&1
;-----------------------------------------------------------------------

STDERR	 equ	2		;error	output handle
STDOUT	 equ	1		;normal output handle

	 assume cs:code, ds:data, es:data, ss:stack

data	 segment para public 'DATA'

pathptr  dd	(?)		;address actual PATH
switch	 dw	'/\'            ;DOS path characters

execpar  dw	(?)		;segment environment
	 dd	(?)		;pointer command line
fcb1	 dd	5Ch		;pointer own 1st FCB
fcb2	 dd	6Ch		;pointer own 2nd FCB

args	 dd	80h		;pointer own arguments

exe	 db	'.\????????.???    EXE'         ;4 blanks for parse FCB
com	 db	'.\????????.???    COM'         ;EXE, COM is executable

comline  db	128 dup (0)	;DTA copy used for DOS external command
command  db	128 dup (0)	;buffer to construct PATH token command

pathtxt  db	'PATH=',0       ;search PATH setting

;-----------------------------------------------------------------------
;	 usage and other messages

usage	 db	13,10,'2&1.EXE, copyright (C) 1991 by Frank Ellermann',13
  db 10,10,'usage: 2&1 [<path>]<name> [<arguments>] [<redirections>]',13
  db 10,10,'or in other words enter "2&1 " followed by Your command'
  db 13,10,'<name> with <path>, <arguments>, and i/o <redirections>'
  db 13,10,'as usual.  2&1 will execute the command redirecting any'
  db 13,10,'STDERR (error) output to STDOUT (normal) output file or'
  db 13,10,'device.',13
  db 10,10,'As an example 2&1 can suppress installation messages on'
  db 13,10,'STDERR if STDOUT is redirected to NUL.  Try "2&1 > NUL"'
  db 13,10,'and "2&1 2&1 > NUL" to see the difference.',13
  db 10,10,'2&1 looks for Your command (if no path specified) first'
  db 13,10,'in actual directory (of specified disk) and then in all'
  db 13,10,'directories of Your PATH until <name>.COM or <name>.EXE'
  db 13,10,'found. You cannot execute BATch files with 2&1 directly,'
  db 13,10,'however "2&1 COMMAND /C [<arguments>] [<redirections>]"'
  db 13,10,'should work with batch files.',13
  db 10,10,'Your PATH is ',0


cannot	 db	13,10,7,'2&1 cannot ',0
misscom  db	'locate "',0
missexe  db	'" ( or EXE )',0
parserr  db	'parse illegal drive or ambiguous command',13,10,0
memory	 db	'start, DOS reports memory management error',13,10,0

dostext  db	13,10,7,'2&1 command not run, DOS call error code '
doscode  db	'00',13,10,0

data	 ends

;-----------------------------------------------------------------------
code	 segment para public 'CODE'

main	 proc	far		;program entry point

	 mov	ax,data 	;install data segment DS
	 mov	ds,ax

	 mov	bx,ss		;SS:SP at end of program
	 mov	ax,es		;ES:0000h at program PSP
	 sub	bx,ax		;paragraph size segments
	 mov	cl,4
	 mov	ax,sp		;offset to stack pointer
	 shr	ax,cl		;converted to paragraphs
	 add	bx,ax		;paragraph size w/ stack

	 mov	ah,4ah		;modify allocated memory to
	 int	21h		;needed size i.e. free rest
	 jnc	envir		;carry flag memory error

	 mov	dx,offset cannot
	 call	message
	 mov	dx,offset memory
	 call	message
	 jmp	doserr

;-----------------------------------------------------------------------
;	 handle arguments and prepare exec parameters

noarg:	 mov	dx,offset usage ;no command argument
	 call	message
	 lds	dx,pathptr	;display PATH if any
	 xor	ax,ax
	 jmp	exitmsg 	;exit with AL 0 okay

envir:	 mov	bx,2Ch		;PSP offset 2Ch environment
	 mov	bx,es:[bx]
	 mov	execpar,bx	;own environmemt segment BX
	 mov	word ptr fcb1+2,es
	 mov	word ptr fcb2+2,es
	 mov	word ptr args+2,es

	 push	ds
	 pop	es		;target ES data segment
	 lds	si,args 	;source DS:SI arguments
	 mov	di,offset comline
	 mov	cx,64		;copy arguments line for
	 rep	movsw		;use as external command

	 push	es
	 pop	ds
	 call	initpath	;search PATH for pathptr

	 mov	si,offset comline
	 mov	di,si		;command name buffer
	 lodsb
	 cbw			;byte 1: size to word
	 mov	cx,ax		;size argument string

testarg: jcxz	noarg		;any character left ?
	 dec	cx
	 lodsb
	 cmp	al,' '          ;skip controls & ' '
	 jbe	testarg 	;blank, tab, lf, etc.

	 dec	si		;1st char. above ' '
	 inc	cx		;rest size inclusive
	 mov	al,byte ptr switch+1
	 mov	ah,'?'          ;switch + '?' ('/?')
	 cmp	[si],ax
	 je	noarg		;caller needs help !

cominc:  cmp	byte ptr [si],' '
	 jbe	comgot		;copy 1st argument to
	 movsb			;command name buffer
	 loop	cominc
comgot:  xor	ax,ax
	 stosb			;AL 0 to name buffer

	 lea	bx,[si-1]	;rest length of arguments
	 mov	[bx],cl 	;to new command line size
	 mov	word ptr execpar+02,bx
	 mov	word ptr execpar+04,ds

	 les	di,fcb1 	;PSP offset 5Ch is 1st FCB
	 mov	ax,2901h	;parse 2nd argument to FCB
	 int	21h		;(skip leading separators)

	 les	di,fcb2 	;PSP offset 6Ch is 2nd FCB
	 mov	ax,2901h	;parse 3rd argument to FCB
	 int	21h		;(incompatible simplified)

;-----------------------------------------------------------------------
;	 parse command to file name, exit if ambiguous or bad drive

	 push	ds
	 pop	es
	 mov	dx,offset comline
	 call	strlen		;lenght of command name
	 mov	di,dx		;scan end of path in DI
	 mov	al,byte ptr switch

haspath: mov	si,di		;keep end of path in SI
	 jcxz	endpath 	;skip specified path
	 repne	scasb		;scan path character AL
	 jz	haspath

endpath: xchg	dx,si		;keep end of path in DX
	 mov	cx,dx		;determine length in CX
	 sub	cx,si		;(use path length excl.
	 push	cx		; command name if given)

	 mov	si,dx
	 mov	di,offset com	;parse '????????.COM',0
	 call	parse		;respect explicit drive

	 mov	si,dx
	 mov	di,offset exe	;parse '????????.EXE',0
	 call	parse		;respect explicit drive

	 pop	cx		;restore path length CX
	 or	al,al
	 jz	search		;bad drive or '*' / '?'

badname: mov	dx,offset cannot
	 call	message
	 mov	dx,offset parserr
	 jmp	exitmsg 	;parse returned error !

;-----------------------------------------------------------------------
;	 search command ( COM or EXE, given path or PATH )

search:  mov	bx,offset command
	 jcxz	nopath		;no path specified ?

	 mov	si,offset comline
	 mov	di,bx		;command file target
	 rep	movsb		;copy specified path

	 mov	dx,offset com+2
	 push	di		;keeping target DI
	 call	strcpy		;try xxx.COM at DI
	 pop	di		;restore target DI
	 mov	dx,bx		;command file path
	 mov	ax,4300h	;test COM existence:
	 int	21h		;get file attribute
	 jnc	gotfile

	 mov	dx,offset exe+2
	 call	strcpy		;try xxx.EXE at DI
	 mov	dx,bx		;command file path
	 mov	ax,4300h	;test EXE existence:
	 int	21h		;get file attribute
	 jnc	gotfile

nofile:  mov	dx,offset cannot
	 call	message
	 mov	dx,offset misscom
	 call	message 	;cannot find COMmand
	 mov	dx,offset com+2 ;EXEcutable program
	 call	message
	 mov	dx,offset missexe
	 call	message 	;tell DOS error code
	 jmp	short doserr

nopath:  mov	dx,offset com	;test COM existence:
	 mov	ax,4300h	;get file attribute
	 int	21h
	 jnc	gotfile

	 mov	dx,offset exe	;test EXE existence:
	 mov	ax,4300h	;get file attribute
	 int	21h

gotfile: jnc	doit

	 call	nextpath	;DI: next PATH token
	 jc	nofile		;command file target

	 mov	dx,offset com+2
	 push	di		;keeping target DI
	 call	strcpy		;try xxx.COM at DI
	 pop	di		;restore target DI
	 mov	dx,bx		;command file path
	 mov	ax,4300h	;test COM existence:
	 int	21h		;get file attribute
	 jnc	gotfile

	 mov	dx,offset exe+2
	 call	strcpy		;try xxx.EXE at DI
	 mov	dx,bx		;command file path
	 mov	ax,4300h	;test EXE existence:
	 int	21h		;get file attribute

	 jmp	gotfile 	;try next PATH token

;-----------------------------------------------------------------------
;	 execute DOS external command, common exit handling

savesp	 dw	(?)		;DOS 2.x exec can destroy SP
savess	 dw	(?)		;DOS 2.x exec can destroy SS

doit:	 mov	bx,STDOUT
	 mov	cx,STDERR
	 mov	ah,46h		;force duplicate handles
	 int	21h		;STDERR to STDOUT output
	 jc	doserr

	 push	ds
	 push	es
	 mov	cs:savess,ss
	 mov	cs:savesp,sp	;DS:DX ASCIIZ command
	 mov	ax,4B00h	;ES:BX exec parameter
	 mov	bx,offset execpar
	 int	21h		;DOS exec function in
	 cli			;DOS 2.x destroys all

	 mov	ss,cs:savess	;no interrupts during
	 mov	sp,cs:savesp	;restauration DS = ES
	 pop	es		;and stack SS:SP
	 pop	ds
	 sti			;interrupts now okay

	 jc	doserr		;if carry exec error

	 mov	ah,4Dh		;get exit code from child
	 int	21h
	 jmp	short exitnul

doserr:  push	ax
	 aam
	 xchg	al,ah
	 or	word ptr doscode,ax
	 pop	ax
	 mov	dx,offset dostext

exitmsg: call	message 	;ASCIIZ DS:DX to STDERR, keep AL
exitnul: mov	ah,4Ch		;terminating with return code AL
	 int	21h

main	 endp

;-----------------------------------------------------------------------
initpath proc	near		;search for path in environment BX

	 push	dx		;modifies AX, CX, DI, SI
	 mov	ax,3700h	;keeping  BX, DX, DS
	 int	21h
	 mov	ax,switch	;get switch character:
	 jc	getenv		;if switch character '/'
	 cmp	dl,ah		;then path character '\'
	 jz	getenv		;else path character '/'
	 mov	al,ah
	 mov	ah,dl
	 mov	switch,ax	;path & switch character

getenv:  pop	dx
	 push	ds
	 mov	word ptr pathptr+2,bx
	 mov	ds,bx		;environment segment
	 xor	ax,ax		;DS:SI start BX:0000
	 mov	si,ax

scanit:  mov	cx,5
	 mov	di,offset pathtxt
	 repe	cmpsb		;look for 'PATH='
	 mov	cx,si		;terminate search at segment limit
	 not	cx		;this will work for length < 64 KB
	 jne	skipit		;CMPSB NOT changed 'PATH=' found ?

	 pop	ds		;restore own data segment
	 mov	word ptr pathptr+0,si
	 ret			;BX:SI is real PATH begin

skipit:  lodsb			;look for terminating NUL byte
	 or	al,al
	 loopnz skipit
	 jcxz	envend		;environment segment > 64 KB ?

	 cmp	[si],al 	;go on with search
	 jne	scanit		;unless double NUL

envend:  pop	ds		;restore own data segment
	 lea	si,[pathtxt+5]
	 mov	word ptr pathptr+0,si
	 mov	word ptr pathptr+2,ds
	 ret			;DS:SI for NUL PATH dummy

initpath endp

;-----------------------------------------------------------------------
nextpath proc	near		;search for path in environment

	 push	ds		;modifies AX, DI, SI
	 mov	ah,11111111b	;yet no character mark
	 mov	di,offset command
	 lds	si,pathptr
	 test	ah,[si]
	 jnz	incpath 	;handle ASCIIZ string end

	 pop	ds		;restore own data segment
	 stc			;indicate PATH end (carry)
	 ret

incpath: lodsb
	 cmp	al,';'
	 je	textend 	;handle PATH token end ';'
	 or	al,al
	 jz	textend 	;handle ASCIIZ string end
	 stosb
	 mov	ah,al		;mark for got a character
	 jmp	incpath

textend: pop	ds		;restore own data segment
	 mov	word ptr pathptr+0,si
	 cmp	ah,11111111b
	 jz	nextpath	;oops, empty path token ?

	 cmp	byte ptr [di-1],':'
	 jz	pathend 	;expect DOS disk character
	 mov	al,byte ptr switch
	 cmp	[di-1],al	;':' or DOS path character
	 jz	pathend 	;otherwise patch '\' ('/')
	 stosb

pathend: clc			;indicate token (no carry)
	 ret			;DI points to end of token

nextpath endp

;-----------------------------------------------------------------------
parse	 proc	near		;parse name SI to filename.ext DI

	 push	di		;modifies AX, CX, DI, SI
	 inc	di		;skip '.' in target data
	 mov	al,byte ptr switch
	 stosb			;reserve e.g. '.\' or 'A:'

	 mov	ax,2908h	;parse command name SI
	 int	21h		;to DI, keep extension
	 or	al,al
	 jz	parseok 	;'*' or '?' or bad drive ?

	 pop	di		;restore initial target
	 ret			;AL > 0 indicates error

parseok: push	di		;keep target
	 mov	cx,8		;copy filename to begin
	 lea	si,[di+1]	;i.e. overwrite drive X
	 rep	movsb
	 mov	al,' '          ;AL is terminator blank
	 stosb

	 pop	di		;kept target
	 lea	si,[di+16]
	 mov	cx,9		;scan for blank end and
	 repne	scasb		;replace by point
	 mov	byte ptr [di-1],'.'

	 mov	cx,3		;copy file extension SI
	 rep	movsb		;executable 'COM'/'EXE'
	 xor	ax,ax		;ASCIIZ terminator
	 stosb

	 pop	di		;restore initial target
	 mov	si,offset comline
	 cmp	byte ptr [si+1],':'
	 jnz	parsend 	;replace dummy path
	 movsw			;by specified drive

parsend: ret			;indicate okay AL 0

parse	 endp

;-----------------------------------------------------------------------
strlen	 proc	near		;return length ASCIIZ string ES:DX

	 xchg	di,dx		;modifies AX, CX
	 mov	cx,di		;keep DX, DI, ES
	 not	cx		;terminate search at segment limit
	 push	di		;this will work for length < 64 KB
	 xor	al,al
	 repne	scasb		;search NUL
	 mov	cx,di		;DI points behind NUL (or is NULL)
	 pop	di		;restore DI
	 sub	cx,di		;length inclusive NUL
	 dec	cx		;length exclusive NUL
	 xchg	dx,di		;restore DX
	 ret			;returns CX string length

strlen	 endp

;-----------------------------------------------------------------------
strcpy	 proc	near		;ASCIIZ string DS:DX to ES:DI

	 push	cx		;modifies AX, DI
	 push	es		;keep CX, DX, ES
	 push	ds
	 pop	es		;set ES = DS
	 call	strlen		;string length CX
	 pop	es		;load old ES
	 jcxz	nulcpy

	 push	di		;target + length
	 add	di,cx		;in segment ES ?
	 jnc	allcpy		;then copy all
	 sub	cx,di		;else truncate

allcpy:  pop	di		;target DI
	 push	si		;saving SI
	 mov	si,dx		;source DX
	 rep	movsb
	 pop	si

nulcpy:  mov	[di],cl 	;target terminator
	 pop	cx		;DI is end of copy
	 ret

strcpy	 endp

;-----------------------------------------------------------------------
message  proc	near		;ASCIIZ string DS:DX to STDERR

	 push	ax		;modifies BX, CX
	 push	es		;keep AX, DX, DS, ES
	 push	ds
	 pop	es		;set ES = DS
	 call	strlen		;CX = strlen( ES:DX )
	 pop	es		;load old ES

	 mov	bx,STDERR	;ASCIIZ string DS:DX to STDERR
	 mov	ah,40h
	 int	21h
	 pop	ax
	 ret

message  endp
code	 ends

;-----------------------------------------------------------------------
stack	 segment para stack 'STACK'

	 dw	128 dup (?)	;stack size in words

stack	 ends
	 end	main		;program entry point
