DGROUP   group  _TEXT
_TEXT    segment use16 para public 'CODE'
         assume cs:DGROUP, ds:DGROUP, es:DGROUP, ss:DGROUP
         org    100h

bootflag proc   far
         mov    ax,0201h
         mov    cx,1
         mov    dx,0080h
         mov    bx,offset buf
         int    13h             ;NC: okay (AH 0)
         jc     fail            ;C: error
         mov    bx,offset buf + 510
         cmp    word ptr [bx],0AA55h
         jnz    fail            ;unexpected formats
         mov    si,81h
         mov    cl,[si-1]       ;CH still 0
         jcxz   show            ;no arguments
skip:    lodsb
         cmp    al,20h
         loope  skip
         sub    al,31h          ;flag boot partition 1..4
         jc     usage           ;< 1, else AL 00..03 etc.
         test   al,11111100b
         jnz    usage           ;> 4, else AL 00..03 okay
         mov    cl,4            ;AH = CH = 0
         shl    ax,cl           ;AX 0..3 to 0000..0030h
delete:  sub    bx,10h
         mov    [bx],ch         ;delete boot flags
         loop   delete
         add    bx,ax           ;insert boot flag:
         mov    byte ptr [bx],80h
         inc    cx              ;CX 1
         mov    ax,0301h
         mov    bx,offset buf
         int    13h
         jc     fail
         jnc    okay

show:    mov    cl,4
scan:    sub    bx,10h
         cmp    byte ptr [bx],80h
         loopne scan
         jne    zero
         inc    cx
zero:    add    cx,2030h
         xchg   ch,cl
         mov    word ptr [msgokay+2],cx
okay:    mov    dx,offset msgokay
         mov    ax,0900h
         jmp    short exit
usage:   mov    dx,offset msgusage
         jmp    short badarg
fail:    mov    dx,offset msgfail
badarg:  mov    ax,0901h
exit:    int    21h
         mov    ah,4Ch
         int    21h
bootflag endp

msgokay  db     "OKAY$"
msgfail  db     "FAIL$"
msgusage db     13,10,"usage: BOOTFLAG [1|2|3|4]",13,10,13,10
         db     "flags partition 1..4 as boot partition",13,10
         db     "or shows the boot partition (0=none)",13,10,"$"
         align  16
buf      label  byte
_TEXT    ends
         end    bootflag
