;-----------------------------------------------------------------------
; creation: MASM CONTILDE, LINK CONTILDE, EXE2BIN CONTILDE CONTILDE.SYS
;-----------------------------------------------------------------------
; Installation: DEVICE[HIGH]=[<drive>:][<path>\]CONTILDE.SYS [<comment>]
; with optionally <drive> and <path> to the CONTILDE.SYS directory.
;
; CO notes the actual INT 29h handler. Whenever CO is opened it swaps
; the noted old and whatever current handler until finally closed. This
; makes sense if ANSI.SYS is installed after CO. ANSI modifies INT 29h
; itself, but some old (!) ANSI.SYS versions don't understand more than
; 25 display lines video modes: Use CTTY CO to bypass ANSI.SYS output
; limitations and CTTY CON to undo this effect. ( Even with intelligent
; ANSI.SYS useful for testing ANSI escape sequence output without going
; into raw console i/o mode. )
;
; WARNING: There may be ill-behaved programs patching INT 29h segment
; directly ( offset 115h ANSI.SYS video colour and page ). If these pro-
; grams crash without ANSI.SYS then they also crash if CO is opened.
;-----------------------------------------------------------------------
; option: define KEYBUF to get a keyboard input buffer at 40:200 for
;         64 characters (instead of 16 at 40:22).  All BIOS routines
;         respect buffer begin (40:80) and end (40:82) offsets, but
;         dumb software might ignore it and try to flush the default
;         buffer directly (without INT 16).  Such software is broken.
;         I had no problems so far with KEYBUF, but a bigger buffer is
;         almost never useful and sometimes annoying.
; option: define MACH32 if and only if you have a buggy MACH32, which
;         reports (= patches) video mode 5Bh for 80x30 text mode 3,
;         although MACH32 does not support mode 5Bh.  This is an ATI
;         patch valid for older cards, but nonsense for MACH32.  The
;         unusual 5B (instead of 3) confuses some tools, e.g. Norton
;         Commander forces mode 3 as soon as it sees anything which
;         is not mode 3 (incl. 5B and 83).
;-----------------------------------------------------------------------

stack    segment para stack     ;dummy makes linker happy
contilde label proc             ;dummy start address
stack    ends

code     segment

         assume cs:code,ds:code,es:nothing,ss:nothing

         dd     -1              ;device link
         dw     1010100000010000b       ;attributes 4,11,13,15
         dw     offset strategy ;device strategy  entry offset
         dw     offset intentry ;device interrupt entry offset
         db     "CO     "      ;character device name

; bit 0: StdOut
;     1: StdIn   resp. 32 bits FAT block device
;     2: NUL
;     3: clock
;set  4: special (support INT 29h fast putchar)
;     6: generic IOCTL (functions 440Ch / 440Dh, driver command 19)
;     7: generic IOCTL (functions 4410h / 4411h, driver command 25)
;set 11: OCR     (support open /close / removeable media functions)
;set 13: busy    (support output till busy / media handling by BPB)
;    14: IOCTL
;set 15: character device

;-----------------------------------------------------------------------
commands dw     offset init     ; 0: initialization
         dw     offset dummy    ; 1: medium test     (only block device)
         dw     offset dummy    ; 2: build BPB       (only block device)
         dw     offset error    ; 3:  input IOCTL    (only IOCTL device)
         dw     offset read     ; 4:  input
         dw     offset rnowait  ; 5:  input no wait  (only char. device)
         dw     offset dummy    ; 6:  input status   (only char. device)
         dw     offset flush    ; 7:  input flush    (only char. device)
         dw     offset write    ; 8: output
         dw     offset write    ; 9: output verify
         dw     offset dummy    ;10: output status   (only char. device)
         dw     offset dummy    ;11: output flush    (only char. device)
         dw     offset error    ;12: output IOCTL    (only IOCTL device)
         dw     offset open     ;13: open            (if OCR bit 11 set)
         dw     offset close    ;14: close           (if OCR bit 11 set)
         dw     offset dummy    ;15: test removable  (block dev. + OCR )
         dw     offset write    ;16: output if ready (char. dev. + busy)
;;       dw     offset error    ;17
;;       dw     offset error    ;18
;;       dw     offset error    ;19: generic IOCTL   (generic bit 6 set)
;;       dw     offset error    ;20
;;       dw     offset error    ;21
;;       dw     offset error    ;22
;;       dw     offset error    ;23: get log. device (block, DOS 3.2 ..)
;;       dw     offset error    ;24: set log. device (block, DOS 3.2 ..)
;;       dw     offset error    ;25: generic IO test (if bits 6 & 7 set)

unknown  equ    ($ - offset commands) shr 1

;-----------------------------------------------------------------------

ahead    dw     0               ;extended ascii type ahead & flag
opened   dw     -1              ;open / close counter, -1 no open
o29      dd     (?)             ;far address old interrupt 29h
d29      dd     (?)             ;far address DOS interrupt 29h
request  dd     (?)             ;request block address pointer

reqsize  equ     0              ;offset request block size
;; unit  equ     1              ;offset [device subunit]
function equ     2              ;offset device function
status   equ     3              ;offset device status word

cread    equ    13              ;offset next available character
buffer   equ    14              ;offset I/O buffer / device end address
count    equ    18              ;offset I/O buffer length bytes[sectors]
config   equ    18              ;offset addr. init. string [BPB pointer]

;; drive equ    13              ;offset medium byte / supported drives
;; major equ    13              ;offset generic IOCTL major function
;; minor equ    14              ;offset generic IOCTL minor function
;; sidi  equ    15              ;offset generic IOCTL SI DI / state word
;; first equ    20              ;offset start sector number word
;; volid equ    22              ;offset drive number/volume ID address
;; sec32 equ    22              ;offset start sector double word

;-----------------------------------------------------------------------
strategy proc   far

         mov    word ptr cs:request,bx          ;ES:BX is address...
         mov    word ptr cs:request+2,es        ;...of request block
         ret

strategy endp

;-----------------------------------------------------------------------
intentry proc   far

         push   ax              ;save registers
         push   bx
         push   cx
         push   dx
         push   di
         push   si
         push   bp
         push   ds
         push   es
         pushf

         cld
         push   cs
         pop    ds              ;address data in code segment

         les    di,request      ;address request with ES:DI
         mov    bl,es:[di+function]
         cmp    bl,unknown      ;check function number
         mov    ax,8003h        ;status unsupported function
         jnb    exit

         shl    bl,1
         xor    bh,bh           ;offset in commands table
         xor    ax,ax           ;call command with AX = 0
         call   [commands+bx]

         les    di,cs:request   ;restore ES:DI request

exit:    or     ax,0100h
         mov    es:[di+status],ax

         popf                   ;restore registers
         pop    es
         pop    ds
         pop    bp
         pop    si
         pop    di
         pop    dx
         pop    cx
         pop    bx
         pop    ax
         ret

intentry endp

;-----------------------------------------------------------------------
error    proc   near
         mov    ax,8003h        ;function not supported
         ret
error    endp

dummy    proc   near            ;you want nothing and
         ret                    ;you will receive it
dummy    endp

;-----------------------------------------------------------------------
write    proc   near            ;output characters

         mov    cx,es:[di+count]
         jcxz   dummy           ;write CX characters

         lds    si,es:[di+buffer]       ;source DS:SI

         mov    bl,7            ;get BH = current page :
         mov    ah,0Fh          ;get video mode function
         push   si
         int    10h             ;BIOS video interrupt
         pop    si

wchar:   mov    ah,0Eh          ;teletype function
         lodsb                  ;output character
         push   si
         int    10h             ;BIOS video interrupt
         pop    si
         loop   wchar

         xor    ax,ax
         ret

write    endp

;-----------------------------------------------------------------------
read     proc   near            ;input  characters

         mov    cx,es:[di+count]
         jcxz   dummy           ;read CX characters

         xor    dx,dx
         les    di,es:[di+buffer]       ;target ES:DI

rchar:   mov    ax,ahead        ;get   type ahead
         mov    ahead,dx        ;clear type ahead
         or     ah,ah
         jnz    gotit           ;got a type ahead ?

         int    16h             ;keyboard read AH 0
         or     al,al
         jnz    gotit           ;no extended ascii ?

         mov    byte ptr ahead,ah       ;keep AH as
         mov    byte ptr ahead+1,1      ;type ahead

gotit:   stosb
         loop   rchar

         xor    ax,ax
         ret

read     endp

;-----------------------------------------------------------------------
rnowait  proc   near            ;non destructive read, no wait

         mov    ax,ahead
         or     ah,ah
         jnz    gotch           ;got a type ahead ?

         inc    ah
         int    16h             ;keyboard status

gotch:   mov    es:[di+cread],al
         mov    ax,0200h        ;char. available ?
         jz     notch           ;sorry, set busy

         xor    ax,ax
notch:   ret

rnowait  endp

;-----------------------------------------------------------------------
flush    proc   near            ;clear input buffer

;;;;;;;; xor    ax,ax
         mov    ahead,ax        ;clear type ahead

next:    mov    ah,1
         int    16h             ;keyboard status
         jz     empty           ;char. available ?

         xor    ax,ax
         int    16h             ;keyboard read
         jmp    next

empty:   xor    ax,ax
         ret

flush    endp

;-----------------------------------------------------------------------
open     proc   near            ;count device open

;;;;;;;; xor    ax,ax
         inc    opened
         jnz    not1st

         cli                    ;restored by POPF at exit
         mov    es,ax           ;get old output interrupt
         les    bx,es:[4*29h]
         mov    word ptr o29+0,bx
         mov    word ptr o29+2,es

         mov    es,ax           ;set DOS output interrupt
         lds    dx,d29
         mov    word ptr es:[4*29h+0],dx
         mov    word ptr es:[4*29h+2],ds

not1st:  ret

open     endp

;-----------------------------------------------------------------------
close    proc   near            ;count device close

;;;;;;;; xor    ax,ax
         dec    opened
         jns    notlast

         cli                    ;restored by POPF at exit
         mov    es,ax           ;set old output interrupt
         lds    dx,o29
         mov    word ptr es:[4*29h+0],dx
         mov    word ptr es:[4*29h+2],ds

notlast: ret

close    endp

;-----------------------------------------------------------------------
        ifdef   MACH32

o10      dd     (?)             ;far address old interrupt 10h

n10      proc   far             ;patched video interrupt

         cmp    ah,0Fh
         je     callo10         ;MACH32 get mode buggy
         jmp    cs:o10          ;other functions okay

callo10: pushf                  ;chain interrupt
         call   cs:o10          ;call old interrupt
         cmp    al,5Bh          ;erroneous mode ?
         jne    exitn10         ;mode is okay
         mov    al,3            ;else patch it
exitn10: iret

n10      endp

        endif
;******************************* non resident section ******************
init     proc   near            ;device initialization

         push   ds
         lds    si,es:[di+config]
         mov    di,offset inbuf ;DS:SI init string
         pop    es              ;ES:DI inbuf

icopy:   lodsb                  ;copy config.sys line
         stosb                  ;parameters to buffer
         cmp    al," "          ;till CR, LF, ^Z etc.
         jnbe   icopy

         push   es              ;CS = DS = ES segment
         pop    ds

         mov    dx,offset crlf
         mov    ah,9            ;new line for message
         int    21h

         dec    di              ;arguments terminator
         mov    byte ptr [di],36
         mov    dx,offset inbuf
         mov    ah,9            ;display device path
         int    21h
         mov    dx,offset dopass
         mov    ah,9            ;display install okay
         int    21h

         les    di,request      ;restore ES:DI request

         mov    ax,offset dummy ;reset init entry to dummy
         mov    commands,ax     ;end address overlay init
         mov    ax,offset init  ;truncate at init offset
         mov    es:[di+buffer+0],ax
         mov    es:[di+buffer+2],ds

         cli                    ;restored by POPF at exit
         xor    ax,ax
         mov    es,ax           ;get DOS output interrupt
         les    bx,es:[4*29h]
         mov    word ptr d29+0,bx
         mov    word ptr d29+2,es

;-----------------------------------------------------------------------
        ifdef   MACH32
         mov    es,ax           ;still CLI and zero AX
         les    bx,es:[4*10h]   ;get old video interrupt
         mov    word ptr o10+0,bx
         mov    word ptr o10+2,es

         mov    es,ax           ;set new video interrupt
         mov    bx,offset n10
         mov    word ptr es:[4*10h+0],bx
         mov    word ptr es:[4*10h+2],cs

        endif
;-----------------------------------------------------------------------
        ifdef   KEYBUF
         assume ds:bios

         mov    bx,seg bios     ;DS = ES = bios segment
         mov    ds,bx
         mov    es,bx
         cmp    [ofsbuf],offset oldbuf
         jnz    endinit         ;keep unknown BIOS buffer

         mov    ah,(31+(offset newend)-(offset newbuf))/32
         mov    di,offset newbuf-10

dirtest: add    di,22           ;skip 22 dir. entry bytes
         mov    cx,10           ;expect 12..21 to be zero
         repe   scasb           ;else new buffer in use ?
         jnz    endinit         ;keep default BIOS buffer
         dec    ah
         jnz    dirtest         ;test IO.SYS scratch area

         mov    ax,offset newbuf
         mov    ofsbuf,ax       ;new buffer begin
         mov    ofsput,ax       ;new buffer clear
         mov    ofsget,ax       ;new buffer end :
         mov    [ofsend],offset newend

         assume ds:code
         push   cs              ;DS = CS = code segment
         pop    ds
         mov    di,offset oldbuf
         mov    si,offset newtxt
         mov    cx,16           ;leave a footprint
         rep    movsw           ;in old key buffer
         mov    dx,offset bufmsg
         mov    ah,9            ;buffer installed
         int    21h             ;message
        endif
;-----------------------------------------------------------------------

endinit: push   cs              ;DS = CS = code segment
         pop    ds
         mov    dx,offset endmsg
         mov    ah,9            ;CO installed
         int    21h             ;message

         xor    ax,ax
         ret

init     endp

;-----------------------------------------------------------------------

crlf     db     13,10,36
dopass   db     " device CO ",36
endmsg   db     "installed - (c) '97 by F. Ellermann",13,10,36

        ifdef   KEYBUF
bufmsg   db     "and buffer ",36
newtxt   db     "New buffer at 40:200 till 40:280"
        endif

inbuf:                          ;input characters collected here

code     ends

;******************************* BIOS RAM segment offsets **************
bios     segment at 0040h       ;for keyboard buffer relocation

         assume ds:bios

         org    1Ah
ofsget   dw     (?)             ;next character read (INT 16h)
ofsput   dw     (?)             ;next character slot (INT 09h)
oldbuf   dw     16 dup (?)      ;old keyboard buffer

         org    80h
ofsbuf   dw     (?)             ;offset buffer begin
ofsend   dw     (?)             ;offset buffer end

         org    200h
newbuf   dw     64 dup (?)      ;new keyboard buffer
newend   dw     (?)             ;IO.SYS scratch area

bios     ends
         end    contilde
