;-----------------------------------------------------------------------
; Installation: DEVICE[high]=[<drive>:][<path>\]CONTILDE.SYS
;-----------------------------------------------------------------------
; Creation: MASM CONTILDE, LINK CONTILDE, EXE2BIN CONTILDE CONTILDE.SYS
; Or:   WASM -wx -we -q -3 -bt=DOS -mt CONTILDE
;       WDIS -l -fi CONTILDE
;       WLINK op q,map format dos com file CONTILDE name CONTILDE.SYS
;-----------------------------------------------------------------------
; History:
; This is a variant for Open Watcom.  Two options of the "vintage 2000"
; version (larger keyboard buffer and MACH32 oddity) have been removed,
; the installation message is also gone.

; The name of this device is CO? with ? = 165 (Alt-1-6-5) for NTilde in
; "OEM" codepages 437, 850, or 858.  Because this is hard to read with
; an "ACP", e.g. 1252, the following text uses CO?.  To build CONTILDE
; for another "OEM" codepage redefine CON equ "CO",165 below.

; Features:
; CO? notes the actual INT 29h handler.  When CO? is opened it swaps the
; noted old and the current handler.  This makes only sense if ANSI.SYS
; is installed after CO?.  ANSI also modifies INT 29h, but some ANSI.SYS
; versions do not support more than 25 display lines.  Use CTTY CO? to
; bypass ANSI.SYS limitations and later CTTY CON to undo this effect.
; Normal CO?.* files are not accessible while CO? is installed, but does
; not affect redirected drives, e.g., MSCDEX or network drives.

; The NT 5.0 (W2K) COMMAND.COM does not more support CTTY, but you can
; use COMMAND CO? to start a subshell and leave it with EXIT.  Likewise
; COMMAND CO? /c xxxxx executes command xxxxx with CO? as console.

; CO? does not offer raw and cooked modes to keep the code simple.  The
; keyboard input is forwarded as is to the caller.  Extended scan codes
; xxE0h are "folded" into traditional xx00h scan codes.  All output goes
; to the actual page of the actual video mode.

; INT 0 is hooked to modify its offset, the old INT 0 handler is still
; used.  The modified offset is 00CDh, embedding an INT 0 opcode CD 00
; in the INT 0 vector.  This might help with erroneous programs trying
; to call a 0000:0000 function pointer.  The initial DOS INT 0 handler
; terminates the running program and displays "divide overflow".

; Invalid opcodes trigger INT 6.  A simple BIOS ROM INT 6 handler might
; process LOADALL and erroneous LOCKs, and otherwise IRET to the invalid
; opcode resulting in a loop.  The new INT 6 handler inserts an INT 3
; break point (if possible for 6 <= SP) and maps the exception either to
; the initial INT 0 or to the old INT 6, if its segment lies below F000h
; (BIOS ROM).  The NTVDM "invalid opcode" message box should still work.

; INT 31h is initialized by BIOS POST (power-on self test) to the dummy
; unexpected interrupt handler in ROM, e.g., F000:B08E.  Later DOS uses
; the INT 30h address at 0000:00C0 for a CP/M BDOS far call at PSP:0005,
; i.e., PSP:0005 calls an alias of 0000:00C0 executing the far jump to a
; BDOS handler at this address.  This far jump begins with an opcode EAh
; followed by the BDOS handler address, e.g., 00A7:xxxx.  The last byte
; of EA xx xx A7 00 overwrites the first byte of INT 31h resulting in an
; invalid F000:B000 instead of F000:B08E.  CO? checks that INT 31h is in
; fact F000:xx00 and installs a handler CS:yy00 jumping to the original
; INT 00h.

; Gimmick:
; If CO? is installed as DEVICE[HIGH]=[path\]CONTILDE.SYS [name] with a
; parameter [name], then this [name] is set as "hostid" using function
; 5E01h of INT 21h.  A native DOS has no NET command for this purpose.

; Options:
; The EXTENDED default is 10h for the extended BIOS keyboard functions.
; Set EXTENDED equ 0 to use INT 16h functions 00/01 instead of 10h/11h.
; Maybe try EXTENDED equ 20h for a BIOS with 122-key functions 20h/21h.
; Non-character key input (xx00h) is always returned as 00h + xxh; this
; includes PAUSE (0000h).  Alt-2-2-4 (00E0h) is always returned as E0h.
; Extended xxE0h input is returned as 00h + xxh.

; Remove FDREAD to disable FDREAD diskette read/write/verify access on
; 21 sectors per track instead of 18, i.e., "tuned" 1.44 MB diskettes.
; The FDREAD code does not patch other diskette parameter tables, and
; might not work if another program also tries to patch the diskette
; parameter table (INT 1Eh) on the fly.

; Define FASTPUT to use the initial DOS INT 29h (fast putchar) instead
; of INT 10 AH 0Eh (teletype output) for character output.  Presumably
; the initial DOS INT 29h also uses the teletype output service.

; The default CONTILDE configuration (incl. FDREAD) occupies 688 bytes.
;                                               (2010, Frank Ellermann)
;-----------------------------------------------------------------------

CON      equ    "CO",165        ;Alt-1-6-5 on keyboards without NTilde
EXTENDED equ    10h             ;10h (extended int 16h functions) or 0
FDREAD   equ    "defined"       ;(delete this line to undefine FDREAD)

.errndef __TINY__               ;DOS device drivers are tiny (DS == CS)
        .286                    ;allow .286 instructions (pusha, etc.)
DGROUP   group  _TEXT
_TEXT    segment use16 para public 'CODE'
         assume nothing
         assume cs:DGROUP

device   dd     -1              ;device link
         dw     1010100000010000b       ;attributes 4,11,13,15
         dw     offset strategy ;device strategy  entry offset
         dw     offset intentry ;device interrupt entry offset
         db     CON,"     "     ;character device name

; bit 0: StdOut
;     1: StdIn
;     2: NUL
;     3: CLOCK$
;set  4: special (support INT 29h fast putchar)
;     6: generic IOCTL (int 21h AH 44h AL 0Ch/0Dh, dev. command 19)
;     7: generic IOCTL (int 21h AH 44h AL 10h/11h, dev. command 25)
;set 11: OCR     (support open / close / removable media functions)
;set 13: busy    (support output until busy / media BPB management)
;    14: IOCTL channel (int 21h AH 44h AL 02h/03h, dev. cmd 3 + 11)
;set 15: character device

;-----------------------------------------------------------------------
commands dw     offset init     ; 0: initialization
         dw     offset badcmd   ; 1: medium test     (only block device)
         dw     offset badcmd   ; 2: build BPB       (only block device)
         dw     offset badcmd   ; 3:  input IOCTL    (only IOCTL device)
         dw     offset input    ; 4:  input
         dw     offset peek     ; 5:  input no wait  (only char. device)
         dw     offset ready    ; 6:  input status   (only char. device)
         dw     offset flush    ; 7:  input flush    (only char. device)
         dw     offset write    ; 8: output
         dw     offset write    ; 9: output verify
         dw     offset ready    ;10: output status   (only char. device)
         dw     offset ready    ;11: output flush    (only char. device)
         dw     offset badcmd   ;12: output IOCTL    (only IOCTL device)
         dw     offset open     ;13: open            (if OCR bit 11 set)
         dw     offset close    ;14: close           (if OCR bit 11 set)
         dw     offset badcmd   ;15: test removable  (block dev. + OCR )
         dw     offset output   ;16: output if ready (char. dev. + busy)
                                ;17: con output stop   (Siemens DOS 4.0)
                                ;18: con output start  (Siemens DOS 4.0)
                                ;19: generic IOCTL   (dev. attr.s bit 6)
                                ;20: con Kana/Kanji    (KKCFUNC DOS 4.0)
                                ;21: reset media flag  (Siemens DOS 4.0)
                                ;22: reserved          (unknown DOS 4.0)
                                ;23: get log. device (only block device)
                                ;24: set log. device (only block device)
                                ;25: generic check   (dev. attr.s bit 7)
UNKNOWN  equ    ($ - offset commands) shr 1

;-----------------------------------------------------------------------
ahead    dw     0               ;extended ascii type ahead & flag
opened   db     -1              ;open / close counter, -1 no open
muxident db     "Frank E "      ;8 manufacturer plus 8 product
         db     "CTTY ",CON,0   ;followed by 0..64 ASCIIZ
LENIDENT equ    ($ - offset muxident)
MUXVERS  equ    200h            ;version 1 (1999) was different
CONTILDE equ    "CONTILDE"
KBMAGIC  equ    "KB",0,0EBh,0,0CBh      ;see AMIS specification

CMD      equ    02              ;offset command
STATUS   equ    03              ;offset status code
CREAD    equ    13              ;offset next available character
GENF     equ    13              ;offset generic IOCTL major/minor func.
BUFFER   equ    14              ;offset I/O buffer / device end address
COUNT    equ    18              ;offset I/O buffer length bytes/sectors
CONFIG   equ    18              ;offset addr. init. string [BPB pointer]
GENP     equ    19              ;offset generic IOCTL parameter address
INIERR   equ    23              ;offset addr. init. error flag (DOS 5+)

;-----------------------------------------------------------------------
; Serialization strategy:  Each request is initialized with status busy.
; If the old request offset is -1 (invalid) a new request can be noted.
; The request offset is invalidated (-1) at the begin of intentry.  If
; the request offset is invalid intentry exits.  A "running" semaphore
; is incremented at the start of intentry and decremented at exit.  The
; initial running value is -1 and permits intentry to process a request.

request  dd     -1              ;request block address pointer
running  db     -1

strategy proc   far
         pushf
         cli
         mov    word ptr es:[bx+STATUS],200h    ;status busy, not ready
         cmp    word ptr cs:request+0,-1        ;at most one request
         jne    intbusy
         mov    word ptr cs:request+0,bx        ;ES:BX is address...
         mov    word ptr cs:request+2,es        ;...of request block
intbusy: popf
         ret
strategy endp

;-----------------------------------------------------------------------
intentry proc   far
         pushf                  ;save registers
         pusha
         push   ds
         push   es
         cld
         push   cs
         pop    ds              ;address data in code segment
         assume ds:DGROUP

         inc    byte ptr running
         jnz    intnop
         les    di,request      ;request ES:DI
         mov    si,-1           ;invalidate request
         cmp    si,di
         je     intnop          ;no pending request
         mov    word ptr request,si

         mov    al,es:[di+CMD]
         cbw                    ;CMD byte AL to word AX
         mov    bx,8003h        ;AX = CMD, BX = status
         cmp    al,UNKNOWN      ;test CMD function number
         xchg   ax,bx           ;BX = CMD, AX = status
         jnb    intbad          ;AX = 8003h unknown function

         add    bx,bx           ;BX = offset of CMD function
         xor    ax,ax           ;call command with AX = 0 ok
         push   es
         push   di
         call   [commands+bx]
         assume ds:nothing      ;commands may modify DS
         pop    di
         pop    es

intbad:  or     ah,1            ;status ready bit
         mov    es:[di+STATUS],ax
intnop:  dec    byte ptr cs:running
         pop    es              ;restore registers
         pop    ds
         popa
         popf
         retf
intentry endp
         align  2

;-----------------------------------------------------------------------
newput   proc   far
         jmp    short jmpput    ;this is actually a "KB" structure...
oldput   dd     0               ;far address old interrupt 29h
         db     KBMAGIC         ;"KB" AMIS specification 3.6 compatible

jmpput:  jmp    cs:[oldput]
newput   endp
         align  2

conput   proc   far
         jmp    short chkput    ;this is actually a "KB" structure...
dosput   dd     0               ;far address new interrupt 29h
         db     KBMAGIC         ;"KB" AMIS specification 3.6 compatible

chkput:  cmp    cs:opened,0
         jns    jmpput          ;open: use initial INT 29h
         jmp    cs:[dosput]     ;else use ANSI.SYS INT 29h
conput   endp
         align  2

;-----------------------------------------------------------------------
;Invalid opcodes trigger INT 06.  A simple BIOS ROM INT 06 handler might
;process LOADALL and erroneous LOCKs, and otherwise IRET to the invalid
;opcode resulting in a loop.  Here INT 06 handler inserts a break point
;(INT 03) and maps the exception either to the initial INT 00 or to the
;old INT 06, if its segment lies below F000h (BIOS ROM).

new_ud   proc   far
         jmp    short chk_ud    ;this is actually a "KB" structure...
old_ud   dd     0               ;far address old interrupt 06h
         db     KBMAGIC         ;"KB" AMIS specification 3.6 compatible

jmp_ud:  jmp    cs:[old_ud]
chk_ud:  cmp    sp,6            ;INT 06 used 6, SP 0 must be bad
         jb     ccskip          ;panic: no stack for break point
         int    3               ;debug: SS:SP => invalid opcode
ccskip:  cmp    byte ptr cs:[old_ud+3],0F0h
         jb     jmp_ud          ;old INT 06 if segment below 0F000h
jmpnul:  jmp    cs:[oldnul]     ;map INT 06 to initial INT 00 handler
new_ud   endp

;-----------------------------------------------------------------------
;Magic INT 31h and INT 00h handlers:  DOS destroys the first byte of the
;"unexpected interrupt" handler in ROM (F000:xxyy), typically resulting
;in a (bad) address F000:xx00.  In this case INT 31h can be secured with
;a dummy CS:0100 handler.
;Address CS:010D is an alias of ssss:00CD for ssss = CS + 4.  ssss:00CD
;contains an embedded INT 0 opcode (CD 00) to catch erroneous 0000:0000
;calls.  KBMAGIC interrupt handlers begin with a short jump followed by
;the old address, based on ssss:00CD this results in an alias ssss:00CF
;for oldnul.  The newnul segment ssss corresponding to offset 00CDh has
;to be determined at runtime when newnul is installed.  Any newnul xxxD
;offset can be used.

ADJUST   =      $
         org    100h            ;fix bad INT 31h F000:xx00 to CS:yy00
.errnz   ADJUST-$ gt 0          ;if error: move newput and/or conput
ADJUST   =      $

new31h   proc   far
         jmp    short jmpnul    ;this is actually a "KB" structure...
old31h   dd     0               ;far address old interrupt 31h
         db     KBMAGIC         ;"KB" AMIS specification 3.6 compatible
         hlt                    ;filler for listing
new31h   endp

         org    ADJUST + 0Dh
         assume cs:nothing      ;---------------------------------------
newnul   proc   far             ;ssss:00CDh is an alias of newnul
         jmp    short farnul    ;this is actually a "KB" structure...
oldnul   dd     0               ;far address old interrupt 0
         db     KBMAGIC         ;"KB" AMIS specification 3.6 compatible

farnul:  jmp    dword ptr cs:[00CFh]
newnul   endp                   ;ssss:00CFh is an alias of oldnul
         assume cs:DGROUP       ;---------------------------------------

;-----------------------------------------------------------------------
newmux   proc   far
         jmp    short chkmux    ;this is actually a "KB" structure...
oldmux   dd     0               ;far address old interrupt 2Dh
         db     KBMAGIC         ;"KB" AMIS specification 3.6 compatible

jmpmux:  jmp    cs:[oldmux]
muxlist  db     00h
         dw     offset newnul
         db     06h
         dw     offset new_ud
        ifdef   FDREAD          ;=== FDREAD patch: =====================
         db     13h
         dw     offset newdsk
        endif                   ;=== end of FDREAD =====================
         db     29h
         dw     offset newput
mux31h:  db     31h             ;2Dh if not installed
         dw     offset new31h   ;newmux for 2Dh
         db     2Dh
         dw     offset newmux

MUXHAND  equ    ($+2)           ;AMIS MUX id. determined by init
chkmux:  cmp    ah,255
         jne    jmpmux          ;-------------------------
         or     al,al           ;AMIS 0: installation test
         jnz    uninst
         not    al              ;AL 255 installed
         mov    cx,MUXVERS      ;version (CH major)
         mov    dx,cs           ;DX:DI identification
         mov    di,offset muxident
         iret                   ;-------------------------
uninst:  cmp    al,2            ;AMIS 2: unistall
         jnz    getlist
         mov    al,5
         cmp    cs:opened,0     ;not open if less than 0
         jns    opinst
         mov    al,7            ;caller may try to
         mov    bx,cs           ;uninstall device
opinst:  iret                   ;-------------------------
getlist: cmp    al,4            ;AMIS 4: get hook list
         jnz    devinfo
         mov    dx,cs           ;DX:BX = MUX hook list
         mov    bx,offset muxlist
         iret                   ;-------------------------
devinfo: cmp    al,6            ;AMIS 6: device info
         jnz    retzero
         mov    ax,1
         mov    dx,cs           ;DX:BX = device header
         xor    bx,bx           ;device offset 0
         iret                   ;-------------------------
retzero: mov    al,0            ;otherwise set AL 0
         iret
newmux   endp
         align  2

;-----------------------------------------------------------------------
; Allow use of sectors 19..21 on floppies supporting 18 sectors.  This
; might not work if other tools also try to patch the INT 1Eh diskette
; parameter table used by DOS.  Clearly the ROM table cannot be patched.

        ifdef   FDREAD          ;=== FDREAD patch: =====================
newdsk   proc   far
         jmp    short chkdsk    ;this is actually a "KB" structure...
olddsk   dd     0               ;far address old interrupt 13h
         db     KBMAGIC         ;"KB" AMIS specification 3.6 compatible

jmpdsk:  jmp    cs:[olddsk]
chkdsk:  cmp    dl,3
         ja     jmpdsk          ;patch only floppy drives DL 0..3
         cmp    ah,2
         jb     jmpdsk
         cmp    ah,4
         ja     jmpdsk          ;patch only 2..4 read/write/verify

         push   bp              ;BP+0: old BP, BP+6: IRET flags
         mov    bp,sp           ;base pointer, BP+2: IRET address
         push   si
         mov    si,0318h        ;18h = 1Bh xor 3, 1Bh = 18h xor 3

         call   near swap21     ;BCD 18h (18) to faked 1Bh (10+11)
         push   [bp+6]          ;\/ copy caller IRET flags
         call   cs:[olddsk]     ;/\ original interrupt 13h
         pushf                  ;result flags (RETF 2)
         pop    [bp+6]          ;result flags (IRET)
         call   near swap21     ;faked 1Bh (10+11) to BCD 18h (18)

         pop    si              ;int 13h AH 2..4 never modifies SI
         pop    bp              ;int 13h AH 2..4 never modifies BP
         iret

swap21:  xchg   ax,si           ;exchange swap value SI and old AX
         push   ds
         push   bx
         xor    bx,bx
         mov    ds,bx
         assume ds:SEGNULL
         lds    bx,[int1Eh]     ;INT 1Eh: diskette parameter table
         assume ds:nothing
         cmp    byte ptr [bx+4],al
         jne    useasis         ;patch only 1.44 MB diskettes (18)
         xor    al,ah           ;18h = 1Bh xor 3, 1Bh = 18h xor 3
         mov    byte ptr [bx+4],al
useasis: pop    bx
         pop    ds
         xchg   ax,si           ;new swap value SI, restore old AX
         retn                   ;near inline proc
newdsk   endp
        endif                   ;=== end of FDREAD =====================

;-----------------------------------------------------------------------
         assume ds:DGROUP, ss:nothing
badcmd   proc   near
         mov    ax,8003h        ;function not supported
ready    label  near
         ret
badcmd   endp

;-----------------------------------------------------------------------
output   proc   near            ;output until busy
         sti                    ;caveat emptor
write    label  near
         mov    cl,COUNT+1      ;expect word at ES:[DI+COUNT]
         call   chkbuf
         mov    cx,es:[di+COUNT]
         jcxz   wcxz            ;write CX characters

         lds    si,es:[di+BUFFER]       ;source DS:SI
        ifndef  FASTPUT         ;-------------------------
         mov    bl,7            ;set BH = current page in
         mov    ah,0Fh          ; get video mode function
         int    10h             ; of BIOS video interrupt
        endif                   ;-------------------------

wchar:   lodsb                  ;output character
        ifndef  FASTPUT         ;-------------------------
         mov    ah,0Eh          ;teletype output function
         int    10h             ; of BIOS video interrupt
        else                    ;-------------------------
         pushf                  ;emulate original INT 29h
         call   cs:[newput]     ;don't use actual INT 29h
        endif                   ;-------------------------
         loop   wchar
wcxz:    xchg   ax,cx           ;AX 0
         ret
output   endp

;-----------------------------------------------------------------------
input    proc   near
         mov    cl,COUNT+1      ;expect word at ES:[DI+COUNT]
         call   chkbuf
         mov    cx,es:[di+COUNT]
         jcxz   rcxz            ;read CX characters

         les    di,es:[di+BUFFER]       ;target ES:DI
rchar:   xor    ax,ax
         xchg   ax,ahead        ;get/clear type ahead
         or     ah,ah
         jnz    gotit           ;got a type ahead ?

         mov    ah,0 + EXTENDED ;extended AH 0
         call   alt224          ;xxE0h to xx00h for xx > 00
         or     al,al           ;Z: any special key
         jnz    gotit           ;NZ: no special key

         mov    byte ptr ahead+0,ah     ;keep AH as
         inc    byte ptr ahead+1        ;type ahead

gotit:   stosb
         loop   rchar
rcxz:    xchg   ax,cx           ;AX 0
         ret
input    endp

;-----------------------------------------------------------------------
alt224   proc   near
         int    16h             ;read/status (AH ?0h/?1h)
         pushf                  ;Z-flag tested in peek
         cmp    al,224          ;extended 224-key (xxEOh)
         jne    not224
         or     ah,ah           ;detect alt-2-2-4 (00E0h)
         jz     not224
         mov    al,0            ;xxE0h to xx00h for xx > 00
not224:  popf
         ret
alt224   endp

;-----------------------------------------------------------------------
chkbuf   proc   near            ;check non-minimal request length
         cmp    es:[di],cl
         ja     usebuf
         pop    ax              ;trash near return address
         mov    ax,8005h        ;bad request
usebuf:  ret
chkbuf   endp

;-----------------------------------------------------------------------
peek     proc   near            ;non destructive read, no wait
         mov    cl,CREAD        ;expect byte at ES:[DI+CREAD]
         call   chkbuf
         mov    ax,ahead
         or     ah,ah           ;Z: no type ahead, ask BIOS
         jnz    gotchar         ;NZ: type ahead available
         mov    ah,1 + EXTENDED ;extended AH 1
         call   alt224          ;xxE0h to xx00h for xx > 00

gotchar: mov    es:[di+CREAD],al
         jnz    okay            ;NZ: character available
         mov    ax,0200h        ;busy status flag 0200h
         ret
peek     endp

;-----------------------------------------------------------------------
flush    proc   near            ;clear input buffer
         mov    ahead,ax        ;clear type ahead

next:    mov    ah,1 + EXTENDED ;extended AH 1
         int    16h             ;keyboard status
         jz     okay            ;char. available ?
         mov    ah,0 + EXTENDED ;extended AH 0
         int    16h             ;keyboard read
         jmp    next
flush    endp

;-----------------------------------------------------------------------
close    proc   near            ;count device close
         cmp    opened,al
         js     okay            ;underflow -1 close
undoinc: dec    opened          ;-1: closed, 0..127: opened

okay:    xor    ax,ax
         ret
close    endp

open     proc   near            ;count device open (0..127)
         inc    opened
         js     undoinc         ;overflow 128 open
         jnz    okay            ;no modifications if opened

         mov    si,offset conput
         cmp    [si+4],ax
         jne    okay            ;set only first new INT 29h in dosput

         mov    es,ax           ;INT 21h AH 35h not reentrant in some
         assume es:SEGNULL      ;DOS versions, grab INT 29h directly:
         les    bx,es:[int29h]
         assume es:nothing

         mov    dx,es           ;noting own newput as "new" dosput
         mov    cx,cs           ;would work once, but better wait
         cmp    cx,dx           ;for a really new ANSI.SYS INT 29h
         je     okay

         mov    dx,si           ;DX     = SI =  offset conput handler
         mov    [si+2],bx       ;[SI+2] = BX =  offset actual handler
         mov    [si+4],es       ;[SI+4] = ES = segment actual handler
         mov    es,ax           ;INT 21h AH 25h not reentrant in some
         assume es:SEGNULL      ;DOS versions, grab INT 29h directly:
         mov    word ptr es:[int29h+0],dx
         mov    word ptr es:[int29h+2],cs
         jmp    okay
open     endp

;-----------------------------------------------------------------------
ADJUST   =      $               ;fill paragraph with CCh (INT 3)
         align  10h             ;resident code end at paragraph
ADJUST   =      $ - ADJUST      ;new offset, align gap 00..0Fh
         org    $ - ADJUST      ;old offset, gap = gap mod 10h
        if      ADJUST mod 08h  ;fill gap to xxx8h or to xxx0h
         db     ADJUST mod 08h dup (0CCh)
        endif
        if      ADJUST mod 10h ge 8
         db     CONTILDE        ;upper gap from xxx8h to xxx0h
        endif

;------------------------------- non-resident section ------------------
         assume es:nothing
init     proc   near            ;device initialization
         inc    si              ;cheap 0 (resident size if init fails)
         mov    es:[di+BUFFER+0],si
         mov    es:[di+BUFFER+2],cs
         mov    cl,INIERR       ;expect byte ES:[DI+INIERR]
         call   chkbuf          ;(implicitly asserts DOS 5+)

         mov    word ptr commands,offset badcmd
         push   es              ;preserve ES:DI request
         push   di

         call   muxtest
         mov    dx,offset msgmux
         jnz    initvec         ;Z: already installed

initerr: mov    ah,09
         int    21h
         pop    di              ;restore ES:DI request
         pop    es              ;report CONFIG.SYS line (DOS 5+)
         inc    byte ptr es:[di+INIERR]
         mov    ax,800Ch        ;general failure
         ret

msgmux   db     13,10,CONTILDE," already installed",07,13,10,"$"

initvec: cli                    ;---------------------------
         mov    al,00h
         mov    si,offset newnul
         call   setint          ;set (non-functional) INT 00h
         mov    bx,cs           ;get "magic" INT 00h segment
         shr    si,4            ;newnul offset ???Dh to 0???h
         lea    bx,[bx+si-0Ch]  ;for segment CS + 0???h - 0Ch
         mov    ds,bx           ;DS:00CDh alias of CS:newnul
         assume ds:nothing
         mov    dx,00CDh        ;CD 00 in address is INT 00h
         mov    ah,25h          ;set magic INT 00h interrupt
         int    21h
         push   cs
         pop    ds
         assume ds:DGROUP
         sti
         mov    al,06h          ;---------------------------
         mov    si,offset new_ud
         call   setint          ;set new #UD interrupt
        ifdef   FDREAD          ;=== FDREAD patch: =====================
         mov    al,13h
         mov    si,offset newdsk
         call   setint          ;set new disk INT 13h
        endif                   ;=== end of FDREAD =====================
         mov    al,29h          ;---------------------------
         mov    si,offset newput
         call   setint          ;set new putchar interrupt
         mov    al,2Dh          ;---------------------------
         mov    si,offset newmux
         call   setint          ;set new AMIS INT 2Dh
         mov    al,31h          ;---------------------------
         mov    di,si           ;DI = offset newmux for undo
         mov    si,offset new31h
         call   setint          ;test garbage INT 31h
         push   ds
         cmp    byte ptr [si+2],0
         jne    undo31h         ;expect address F000:xx00
         cmp    word ptr [si+4],0F000h
         je     init31h         ;fixed new INT 31h
undo31h: mov    byte ptr mux31h+0,2Dh
         mov    word ptr mux31h+1,di
         lds    dx,[si+2]
         mov    ah,25h          ;reset old INT 31h
         int    21h
init31h: pop    ds

         pop    di              ;restore ES:DI request
         pop    es              ;resident size:
         mov    es:[di+BUFFER+0],offset init
         call   initid
         xor    ax,ax
         ret                    ;AX = 0 (done)
init     endp

;-----------------------------------------------------------------------
setint   proc   near
         mov    ah,35h          ;fetch ES:BX = address old handler
         int    21h
         mov    dx,si           ;DX     = SI =  offset new handler
         mov    [si+2],bx       ;[SI+2] = BX =  offset old handler
         mov    [si+4],es       ;[SI+4] = ES = segment old handler
         mov    ah,25h
         int    21h             ;install new int AL handler DS:DX
         ret
setint   endp

;-----------------------------------------------------------------------
initid   proc   near
         push   ds
         lds    si,es:[di+CONFIG]
         assume ds:nothing
         push   cs
         pop    es
         mov    ah,20h          ;AH = space
init_w1: lodsb                  ;skip visible characters (own path)
         cmp    al,ah
         ja     init_w1
         jb     initnot         ;EOL: no optional argument
init_s1: lodsb                  ;skip space(s)
         cmp    al,ah
         je     init_s1
         jb     initnot         ;EOL: no optional argument
         mov    dx,offset msgmux+2
         mov    di,dx           ;DI = DX = msgmux+2  used as buffer
         mov    cx,15           ;CX = length of blank padded hostid
init_w2: jcxz   init_s2
         dec    cx
         stosb                  ;copy characters (incl. spaces)
         lodsb
         cmp    al,ah
         jae    init_w2
         mov    al,ah           ;AL = space
         rep    stosb           ;padding
init_s2: pop    ds
         assume ds:DGROUP
         mov    ax,5E01h
         mov    cx,0100h        ;CH 1: set name, CL 0: first name
         int    21h
         jnc    initret
         dec    dx
         dec    dx
         mov    si,offset msgpad
         mov    cx,11           ;length of msgpad (incl. dollar)
         rep    movsb
         mov    ah,9            ;display warning if hostid not set
         int    21h
initret: ret                    ;ES, DI, SI, AX, CX, DX modified

msgpad   db     " not set",13,10,"$"

initnot: pop    ds
         ret
initid   endp

;-----------------------------------------------------------------------
muxtest  proc   near            ;modifies ES:DI, SI, AX, BX, CX, DX
         mov    bx,0FF00h       ;MUX installation check
muxloop: mov    ah,bl
         mov    al,0
         int    2Dh
         or     al,al           ;free handle if AL 0
         jz     muxfree
         mov    si,offset muxident
         mov    es,dx           ;DX:DI identification
         mov    cx,LENIDENT
         repe   cmpsb
         jne    muxnext
         ret                    ;Z: already installed

muxfree: cmp    bl,bh
         jnb    muxnext         ;skip if not first free
         mov    bh,bl           ;note first free handle
muxnext: inc    bl              ;next handle BL (1..255)
         jnz    muxloop
         mov    MUXHAND,bh      ;use 1st MUX handle
         inc    bh              ;Z: no free MUX handle
         ret                    ;NZ: okay (handle set)
muxtest  endp

;------------------------------- system data ---------------------------
_TEXT    ends
SEGNULL  segment use16 at 0 private 'FAR_BSS'   ;improve WDISasm listing
        ifdef   FDREAD          ;=== FDREAD patch: =====================
         org    4*1Eh
int1Eh   dd     1 dup (?)       ;diskette parameter table (FDREAD)
         public int1Eh          ;public symbol for WDISasm listing
        endif                   ;=== end of FDREAD =====================
         org    4*29h
int29h   dd     1 dup (?)       ;fast putchar (DOS console output)
         public int29h          ;public symbol for WDISasm listing
SEGNULL  ends

         public request         ;public symbols for WDISasm listing
         public running         ;intentry semaphore
         public ahead           ;type ahead buffer (char. + flag)
         public opened          ;dev. open counter (-1 if closed)
         public muxident        ;AMIS ident. (installation check)
         public muxtest         ;AMIS installation
         public setint
         public initid          ;hostid

         public newmux          ;int 2Dh (Alt. Multiplex Int. Spec.)
         public oldmux
         public newnul          ;int 00h integer divide overflow
         public oldnul
         public new_ud          ;int 06h undefined opcode
         public old_ud
         public new31h          ;int 31h destroyed by DOS
         public old31h
         public newput          ;int 29h fast putchar (initial)
         public oldput
         public conput          ;int 29h fast putchar (current)
         public dosput
        ifdef   FDREAD          ;=== FDREAD patch: =====================
         public newdsk          ;int 13h disk interrupt (FDREAD)
         public olddsk
        endif                   ;=== end of FDREAD =====================

         public strategy        ;device request (stored in request)
         public intentry        ;devive interrupt (execute request)

         public commands        ;device commands table:
         public badcmd          ;fail
         public ready           ;okay
         public chkbuf          ;used by input + peek + write
         public alt224          ;used by input + peek
         public input           ;read
         public peek            ;non-destructive read, no wait
         public flush
         public write           ;output
         public output          ;output until busy
         public open
         public close
         public init            ;used once (not resident)

         end    device
