;************************************************************************
; Modified Open Watcom C/C++ DOS 16-bit ..\STARTUP\DOS\CSTRT086.ASM code.
; For __TINY__ (COM) stored in ..\LIB286\DOS\CSTART_T.OBJ use:
;       set WASM=-we -wx -zld -1r -bt#DOS
;       wasm -q %WASM% -mt cstart_t
; The __SMALL__ and __COMPACT__ cstart.obj in CLIB?.LIB are identical:
;       wasm -q %WASM% -ms cstart_t -focstart -nmcstart
;       wlib -q clibs -+cstart.obj
;       wasm -q %WASM% -mc cstart_t -focstart -nmcstart
;       wlib -q clibc -+cstart.obj
; Identical __MEDIUM__, __LARGE__, and __HUGE__ objects in CLIB?.LIB:
;       wasm -q %WASM% -mm cstart_t -focstart -nmcstart
;       wlib -q clibm -+cstart.obj
;       wasm -q %WASM% -ml cstart_t -focstart -nmcstart
;       wlib -q clibl -+cstart.obj
;       wasm -q %WASM% -mh cstart_t -focstart -nmcstart
;       wlib -q clibh -+cstart.obj
; Unverified, CLIBOM and CLIBM libraries may differ wrt overlays:
;       wasm -q %WASM% -mm cstart_t -focstart -nmcstart -dOVERLAY
;       wlib -q clibom -+cstart.obj
; Unverified, CLIBOL and CLIBL libraries may differ wrt overlays:
;       wasm -q %WASM% -ml cstart_t -focstart -nmcstart -dOVERLAY
;       wlib -q clibol -+cstart.obj
;************************************************************************
; Differences between this CSTART_T.ASM and CSTRT086.ASM (2003-11-20):
;  1 -  The __TINY__ case for "format dos com" was integrated into
;       the normal _cstart_ handling using __TINY__ "CSGROUP equ cs"
;       vs. "CSGROUP equ DGROUP" in all other models.
;  2 -  There was no __TINY__ NULL pointer assignmemt check at exit,
;       now 20CDh at PSP:0 is expected to survive.
;  3 -  WLINK enforces a minimal stack size of 512 for *.EXE files.
;       The minimal __TINY__ stack size is now the same value 512
;       instead of 2048.  The total stack size at C runtime startup
;       is now always stored in __stacksize.  WLINK cannot set the
;       __TINY__ stack size, it has to be declared in a variable,
;       e.g., size_t volatile __stacksize = 512;  The default stack
;       size for __TINY__ is still 2048.
;  4 -  The DGROUP including stack is still limited to 64 KB.  If a
;       far stack (SS != DGROUP) cannot be aligned with the DGROUP
;       a _Not_Enough_Memory_ error exit is triggered.
;  5 -  A _Not_Enough_Memory_ error and the added NULL errors will
;       now exit if the debugger returns from fatal runtime errors.
;       The old code apparently assumed that this cannot happen.
;  6 -  The __do_exit_with_msg__ code did not set DS for __TINY__
;       access on "con"; this is now handled as in all other models.
;       The __do_exit_with_msg__ code now verifies that open "con"
;       actually worked and uses STDERR otherwise.  For DOS 2 and
;       3.x AVAILDEV compatibility (see INT 21h AH 37h) "\dev\con"
;       is used instead of "con".
;  7 -  The __do_exit_with_msg__ stack is now word aligned for an
;       odd _end.  Now SS:SP instead of only SP is reset.
;  8 -  offset DGROUP:_edata (1) and offset DGROUP:_end (4) replaced
;       by simple offsets to get rid of obscure segment overrides.
;  9 -  The "dynamic halt" for a NULL call has been replaced by a
;       fatal runtime error inspired by code in 386\CSTRTX32.ASM.
; 10 -  NULL pointer calls in the first physical code segment of
;       far code models are now trapped as in near models.  Really
;       far 0000:0000 calls are trapped by a modified INT 0 handler
;       with an INT 0 (CD 00) in its own address xxxx:00CDh.
; 11 -  The _nullarea was reduced from 16 to 6 words 00CDh instead
;       of 0101h.  Again 00CDh triggers INT 0 if a NULL pointer in
;       the _nullarea is called.
; 12 -  The command line copy now handles length 0 as 0 instead of
;       1 (REPE SCASB needs a set Z-flag if CX can be 0).  Clearing
;       _BSS and stack instead of only _BSS simplified the code.
; 13 -  Old %WATCOM%\STARTUP\DOS\MDEF.INC definitions are replaced
;       by "CSLABEL equ far" and "CSLABEL equ near" for the far and
;       near code models.  Apparently MDEF.INC was removed from the
;       Open Watcom ..\STARTUP\DOS directory (good riddance).
; 14 -  Overlay code is now only generated if OVERLAY is defined.
;       Maybe this was the original idea of clib[lm] vs. clibo[lm].
;       However, there is no cliboh.lib to support this theory.
;       Stack frame (push bp + mov bp,sp) now always used, not only
;       if OVERLAY defined.
; 15 -  A .286p directive was downgraded to .186.  The startup code
;       does not use .286 instructions.  The recommended option -0r
;       for CSTRT086.ASM anyway only allowed 808[86] instructions.
;       For CSTART_T.ASM option -1r allows three .186 instructions;
;       compare "shr bx,4", "shr di,4", and "push CSGROUP" below.
;       Use WASM options -0r -d__SW_0r to get pure 808[86] code.
;       Unfortunately WASM does not yet automatically define __SW_x
;       for option -x (unlike all Open Watcom C/C++ compilers).
; 16 -  As it turns out the C runtime library calls __RmTempFileFn
;       in module fclose even if that is a null pointer.  Compiler
;       option -d2 (create debug info) apparently avoids this bug.
;************************************************************************
; Requires:     Open Watcom Assembler 1.2       (Frank Ellermann, 2010)

        name    cstart
        assume  nothing

       ifndef   __SW_0r
        .186                    ;permit use of three 80186 instructions
       endif

       ifdef    __TINY__
DGROUP  group   _TEXT,CONST,STRINGS,_DATA,DATA,XIB,XI,XIE,YIB,YI,YIE,_BSS
CSGROUP         equ     cs              ; cannot use segment relocation
PSP             equ     DGROUP          ; dummy to clarify some "assume"
CSLABEL         equ     near
       else                     ;;;;;;; EXE code models ;;;;;;;;;;;;;;;;;
DGROUP  group   _NULL,CONST,STRINGS,_DATA,DATA,XIB,XI,XIE,YIB,YI,YIE,_BSS,STACK
CSGROUP         equ     DGROUP          ; segment relocation is required
PSP             equ     nothing         ; dummy to clarify some "assume"
CSLABEL         =       near
       ifndef   __SMALL__
       ifndef   __COMPACT__
CSLABEL         =       far     ;;;;;;; far code models ;;;;;;;;;;;;;;;;;
       ifndef   __MEDIUM__
       ifndef   __LARGE__
       ifndef   __HUGE__
        .err                            ; __FLAT__ model not supported
       endif    ; not __HUGE__
       endif    ; not __LARGE__
       endif    ; not __MEDIUM__
       endif    ; not __COMPACT__
       endif    ; not __SMALL__
       endif    ; not __TINY__  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;-----------------------------------------------------------------------;
; Imported symbols                                                      ;
;       Note that CSLABEL equates to near or far for the corresponding  ;
;       near (tiny, small, compact) or far (medium, large, huge) code   ;
;       models.                                                         ;
;       Apparently _close_Ovl_file is used by __doexec, therefore three ;
;       far pointers for overlays are initialized by a dummy RETF here. ;
;-----------------------------------------------------------------------;

        extrn   __CMain                 : CSLABEL
        extrn   __InitRtns              : CSLABEL
        extrn   __FiniRtns              : CSLABEL
        extrn   __fatal_runtime_error_  : CSLABEL

        extrn   _edata                  : byte  ; end of DATA, start of BSS
        extrn   _end                    : byte  ; end of BSS, start of STACK
        extrn   __stacksize             : word  ; total startup stack size

        extrn   "C",_curbrk             : word
        extrn   "C",_psp                : word
        extrn   "C",_osmajor            : byte
        extrn   "C",_osminor            : byte
        extrn   __osmode                : byte
        extrn   "C",_STACKLOW           : word
        extrn   "C",_STACKTOP           : word
        extrn   "C",_child              : word
        extrn   __no87                  : word
        extrn   ___FPE_handler          : word  ; actually a far address
        extrn   "C",_LpCmdLine          : word  ; actually a far address
        extrn   "C",_LpPgmName          : word  ; actually a far address
        extrn   __get_ovl_stack         : word  ; actually a far address
        extrn   __restore_ovl_stack     : word  ; actually a far address
        extrn   __close_ovl_file        : word  ; actually a far address
        extrn   ___Exec_addr            : word  ; or dword in far models

;-----------------------------------------------------------------------;
; BEGTEXT segment                                                       ;
;       BEGTEXT used to be a "dynamic halt" (X: int 3; jmp short X) in  ;
;       other versions.  This version triggers an INT 0 followed by a   ;
;       __fatal_runtime_error_ if INT 0 returns.                        ;
;                                                                       ;
;       WLINK keeps BEGTEXT in front to catch erroneous near NULL calls ;
;       especially in near code models.  In far code models BEGTEXT can ;
;       still catch near NULL calls in the first physical code segment. ;
;       The 00CDh (INT 0) at the begin of BEGTEXT is checked by __exit  ;
;       for erroneous NULL pointer assignments.                         ;
;       __TINY__ has no BEGTEXT, it has an INT 20h (CD20h) at the begin ;
;       of the PSP.                                                     ;
;-----------------------------------------------------------------------;

       ifndef   __TINY__        ;;;;;;; TINY gets no NULL call trap ;;;;;
BEGTEXT segment use16 word public 'CODE'
        assume  cs:BEGTEXT
        int     0                       ; trigger INT 0, if it returns:
nulled: jmp     nullerr                 ; fatal error, inform debugger
BEGTEXT ends

;-----------------------------------------------------------------------;
; _NULL segment                                                         ;
;       _NULL used to be 16 words with the pattern 0101h checked in the ;
;       __exit processing to report NULL pointer assignments.  A rather ;
;       obscure _AFTERNULL segment contained 0000h.  The old cstart did ;
;       not inform the debugger if present, and there was no NULL check ;
;       for __TINY__.                                                   ;
;                                                                       ;
;       This cstart version uses the pattern 00CDh to find NULL pointer ;
;       assignments, because a DGROUP NULL pointer call will trigger an ;
;       INT 0 (CD 00) for 00CDh.                                        ;
;                                                                       ;
;       For __TINY__ now 20CDh (CD 20, INT 20h) at the begin of the PSP ;
;       is expected to survive.  In other models _NULL contains six     ;
;       words 00CDh followed by the INT 0 handler "magic" offset 0Dh as ;
;       explained below.  The _AFTERNULL segment was removed, the total ;
;       size of the _NULL segment is as before 32 bytes.                ;
;-----------------------------------------------------------------------;

_NULL   segment use16 para public 'BEGDATA'
NULLVAL equ     00CDh                   ; INT 00h for bad NULL calls
NULLDUP equ     6                       ; 6 words checked for changes
__nullarea      label word
        dw      NULLDUP dup (NULLVAL)
        int     3                       ; filler for "magic" offset 0Dh
        assume  nothing                 ; CS != _TEXT set up by nullini
__int0_AMIS     label CSLABEL           ; Interrupt Sharing Protocol:
        jmp     short null_s            ;       short jump to ISR code
        dd      0                       ;       saved old INT 00h vector
        db      "KB",0,0EBh,0,0CBh      ;       "KB" protocol signature
null_s: db      0EAh                    ; CS = _TEXT set by a far jump
        dd      offset null_f           ; segment fixup done by nullini

        dw      offset nulled           ; avoid dead code elimination
_AFTERNULL      label CSLABEL           ; maybe remove this completely
        public  _AFTERNULL              ; public symbol for debugger
        public  __nullarea              ; public symbol for debugger
_NULL   ends
       else                     ;;;;;;; TINY null check tests PSP:0 word:
NULLVAL equ     20CDh                   ; INT 20h at begin of PSP
NULLDUP equ     1
       endif                    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

CONST   segment use16 word public 'DATA'
CONST   ends
STRINGS segment use16 word public 'DATA'
STRINGS ends
_DATA   segment use16 para public 'DATA'
_DATA   ends
DATA    segment use16 word public 'DATA'
DATA    ends
XIB     segment use16 word public 'DATA'
XIB     ends
XI      segment use16 word public 'DATA'
XI      ends
XIE     segment use16 word public 'DATA'
XIE     ends
YIB     segment use16 word public 'DATA'
YIB     ends
YI      segment use16 word public 'DATA'
YI      ends
YIE     segment use16 word public 'DATA'
YIE     ends

;-----------------------------------------------------------------------;
; _BSS  segment                                                         ;
;       Cleared by _cstart_.  Three OVERLAY variables added to _BSS.    ;
;       WLINK creates two labels _edata (end of DGROUP data segments,   ;
;       begin of _BSS) and _end (end of _BSS, begin of STACK) for us.   ;
;-----------------------------------------------------------------------;

_BSS    segment use16 word public 'BSS'
       ifdef    OVERLAY         ;;;;;;; assume MEDIUM / LARGE overlays ;;
        public  __ovlflag               ;; only for people who link with
        public  __intno                 ;; MS Linker and use CodeView for
        public  __ovlvec                ;; debugging overlayed programs
__ovlflag       db 1 dup (?)            ; non-zero if program overlayed
__intno         db 1 dup (?)            ; MS Overlay Manager interrupt
__ovlvec        dd 1 dup (?)            ; saved prior interrupt handler
       endif                    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
_BSS    ends

;-----------------------------------------------------------------------;
; STACK and FAR_DATA segments                                           ;
;       Only for EXE-programs:  COM-programs have a stack, but no stack ;
;       segment (enforced by WLINK).  The FAR_DATA segment does not     ;
;       belong to the DGROUP and is not used here, but like all other   ;
;       segments defined here it gets the use16 attribute.              ;
;-----------------------------------------------------------------------;

STKMIN  equ     512                     ; minimal size enforced by WLINK
       ifndef   __TINY__        ;;;;;;; EXE code STACK segment ;;;;;;;;;;
STACK   segment use16 para stack 'STACK'
        db      (STKMIN) dup (?)        ; complete program path + name +
STACK   ends                            ; arguments stored @ stack bottom

FAR_DATA segment use16 byte public 'FAR_DATA'
FAR_DATA ends

_TEXT   segment use16 word public 'CODE'
       else                     ;;;;;;; TINY stack gets no own segment ;;
_TEXT   segment use16 para public 'CODE'
        org     0100h                   ; format dos com starts at 100h
       endif                    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;-----------------------------------------------------------------------;
; _TEXT segment                                                         ;
;       For COM-programs WLINK arranges _TEXT as first DGROUP segment.  ;
;       There are no segments outside of the DGROUP for COM-programs.   ;
;       For COM-programs the _TEXT segment conceptually contains the    ;
;       PSP followed by _cstart_ at offset 100h.                        ;
;       COM-programs can work with data in other segments outside of    ;
;       the DGROUP at runtime, but as far as WLINK is concerned they    ;
;       are limited to 64 KB in one DGROUP.                             ;
;                                                                       ;
;       For EXE-programs WLINK arranges _TEXT and other CODE segments   ;
;       after BEGTEXT before the DGROUP starting with a _NULL segment.  ;
;       For EXE-programs the PSP is a separate segment created by the   ;
;       DOS exec-function before all other segments.                    ;
;                                                                       ;
;       For EXE-programs _cstart_ does not immediately follow the PSP.  ;
;       In the near code models all code segments belong to one 64 KB   ;
;       group starting with BEGTEXT, i.e., they use the same CS value   ;
;       and (typically) near function calls.                            ;
;                                                                       ;
;       In far code models WLINK can arrange far code segments in many  ;
;       groups, and the 64 KB limit then only affects individual code   ;
;       segments.  The first code segment group still starts with the   ;
;       BEGTEXT segment; this permits to catch near NULL pointer calls  ;
;       in this group.  All public functions in far code segments have  ;
;       to be called with far calls.                                    ;
;-----------------------------------------------------------------------;

        assume  nothing
        assume  cs:_TEXT

_cstart_ proc
        public  _cstart_
        mov     cx,CSGROUP              ; DGROUP is CS for __TINY__
        mov     ds,cx                   ; CX = DS used below
        assume  ds:DGROUP, es:PSP

        mov     _psp,es                 ; save segment address of PSP
        mov     bx,offset _end          ; get bottom of stack
       ifndef   __TINY__        ;;;;;;; use given EXE stack size ;;;;;;;;
        mov     ax,sp                   ; determine EXE start stack top
       else                     ;;;;;;; force minimal TINY stack ;;;;;;;;
        mov     ax,__stacksize          ; get size of required COM stack
       endif                    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        cmp     ax,STKMIN               ; make sure stack size is at
        jae     goodsp                  ; least the WLINK minimum 512
        mov     ax,STKMIN
goodsp: add     bx,ax                   ; calculate stack top in DGROUP
        jnc     goodss                  ; DGROUP size limit below 64 KB

_Not_Enough_Memory_:
        public  _Not_Enough_Memory_
        mov     ax,offset enomem        ; report various DGROUP issues
        jmp     fatal                   ; fatal error, inform debugger

goodss: mov     ax,65520                ; DGROUP limit 0FFFh paragraphs
        sub     bx,ax                   ; (max. 14 lost bytes simplify
        jnc     _Not_Enough_Memory_     ;  the code here substantially)
        and     bx,ax                   ; alignment (65520 = 0FFF0h)
        mov     ss,cx                   ; set stack segment SS = DS
        mov     sp,bx                   ; set sp relative to DGROUP
        assume  ss:DGROUP
        xchg    cx,ax                   ; AX = DS
       ifdef    __SW_0r                 ; 8088 / 8086 code:
        mov     cl,4
        shr     bx,cl                   ; number of paragraphs needed
       else                             ; 80186 (or better) code:
        shr     bx,4                    ; number of paragraphs needed
       endif
        cmp     byte ptr __osmode,0     ; not 0 for ERGO 286 extender
        jne     osmode                  ; (this is of course historic)

        mov     _curbrk,sp              ; top of memory owned by process
        mov     si,word ptr es:[0002h]  ; get highest segment address
        sub     si,ax                   ; SI = paragraphs available
        cmp     bx,si                   ; BX = paragraphs wanted
        jnb     _Not_Enough_Memory_
;
;       free up memory beyond the end of the stack in small data models
;               and beyond the 64K data segment in large data models
;
        add     bx,ax                   ; add start of data segment
        mov     ax,es                   ; minus segment of PSP
        sub     bx,ax
        mov     ah,4Ah                  ; "SETBLOCK" function
        int     21h                     ; free up the memory
        jc      _Not_Enough_Memory_     ; fatal, DOS memory corruption
;
;       clear _BSS and stack (the following near heap is still empty)
;
osmode: mov     di,offset _edata        ; end of DATA, start of BSS
        push    es                      ; ES = PSP
        push    ds                      ; DS = DGROUP
        pop     es                      ; ES = DGROUP
        pop     ds                      ; DS = PSP
        assume  ds:PSP, es:DGROUP       ; ES:DI start of _BSS
        xor     ax,ax
        cwd                             ; DX 0 indicates NO87 not set
        mov     cx,sp
        sub     cx,di                   ; length _BSS + stack
        cli                             ; no interrupt, stack cleared
        rep     stosb                   ; zero near _BSS segment
        sti
;
;       copy command line into bottom of stack, keep DX = 0
;
        mov     di,offset _end          ; end of BSS, start of STACK
        mov     si,81h                  ; command buffer PSP:81h
        mov     cl,byte ptr [si-1]      ; CX length of command
        jcxz    noargs
spaces: cmp     byte ptr [si],20h       ; skip leading spaces
        jne     argcpy
        inc     si
        loop    spaces
argcpy: rep     movsb                   ; copy command line to ES:DI
noargs: inc     di                      ; NUL terminator for cmdline
;
;       note cmdline and program pointers, get DOS version, keep DX = 0
;
        mov     si,word ptr ds:[002Ch]  ; segment of environment area
        push    es                      ; ES = DGROUP
        pop     ds                      ; DS = DGROUP
        assume  ds:DGROUP
        mov     _LpCmdLine+0,offset _end
        mov     _LpCmdLine+2,ds         ; DS:_end cmdline pointer
        mov     _LpPgmName+0,di         ; DS:DI = program pointer
        mov     _LpPgmName+2,ds

        mov     ah,30h                  ; get DOS version number
        int     21h                     ; AX, BX, and CX are modified
        mov     _osmajor,al
        mov     _osminor,ah
        cmp     al,2                    ; DOS 2 had no program name at
        jbe     pgmnul                  ; end of the environment block
;
;       copy the program name into bottom of stack, finally use DX = 0
;
        mov     ds,si                   ; segment of environment area
        assume  ds:nothing              ; DS = environment
        mov     si,dx                   ; SI = DX = 0 (start offset)
scanit: mov     ax,[si]                 ; begin of environment string
        or      ax,2020H                ; case insensitive comparison
        cmp     ax,"on"                 ; 'on' for "NO", "No", "no", ...
        jne     skipit
        cmp     word ptr [si+2],"78"    ; '78' for "87"
        jne     skipit
        cmp     byte ptr [si+4],"="     ; '=' for NO87=value string
        jne     skipit
        inc     dx                      ; count less than 256 NO87=
skipit: cmp     byte ptr [si],dh        ; end of environment string ?
        lodsb                           ; inc SI preserving flags
        jne     skipit                  ; end of environment area ?
        cmp     byte ptr [si],dh
        jne     scanit                  ; next environment string
        inc     si                      ; inc SI destroying flags
        lodsw                           ; ignore DOS 3+ word 0001h
pgmcpy: movsb                           ; copy program name character
        cmp     byte ptr [si],dh        ; source is NUL terminated
        jne     pgmcpy

pgmnul: inc     di                      ; NUL terminator for program
        push    es                      ; ES = DGROUP
        pop     ds                      ; DS = DGROUP
        assume  ds:DGROUP               ; SS = DGROUP
        mov     __no87,dx               ; store "NO87" counter DX as is
        mov     _STACKLOW,di            ; store bottom of stack
        mov     _STACKTOP,sp            ; store top of stack
        mov     cx,sp
        sub     cx,di                   ; remaining size can be odd:
        mov     __stacksize,cx          ; store remaining stack size
;
;       initialize dummy handlers and stack frame
;
        xor     ax,ax                   ; AX = 0
        mov     cx,offset dummy         ; dummy RETF handler address
        cmp     word ptr __get_ovl_stack,ax
        jnz     is_ovl                  ; if program not overlayed:
        mov     __get_ovl_stack+0,cx    ; set vectors to dummy RETF
        mov     __get_ovl_stack+2,cs
        mov     __restore_ovl_stack+0,cx
        mov     __restore_ovl_stack+2,cs
        mov     __close_ovl_file+0,cx
        mov     __close_ovl_file+2,cs
is_ovl: mov     ___FPE_handler+0,cx     ; install dummy FPE handler
        mov     ___FPE_handler+2,cs

        xchg    ax,bp                   ; BP = 0 initial stack frame
        push    bp                      ; BP = SP for overlay manager
        mov     bp,sp                   ; preserve BP after this point
        mov     ax,00FFh                ; all priorities 0 up to AL 255
        call    __InitRtns              ; call all initializer routines
        call    nullini                 ; use  __InitRtns "doexec" info
        call    __CMain                 ; after __CMain go to __exit
_cstart_ endp

__exit  proc                            ; AL = return code
        public  "C",__exit
        mov     cx,CSGROUP              ; DGROUP is CS for __TINY__
        mov     es,cx
        assume  ds:nothing, es:DGROUP, ss:nothing
        xchg    ax,bx                   ; BL = return code
        cld                             ; direction for null check
        mov     cx,NULLDUP              ; number of words to check
        mov     ax,NULLVAL              ; null pointer check value
        xor     di,di                   ; ES:DI points to DGROUP:0
        repe    scasw                   ; scan NULLDUP NULLVAL in AX
       ifndef   __TINY__        ;;;;;;; TINY has no BEGTEXT to check ;;;
        jne     gotcha                  ; fatal, DGROUP:0 modified
        mov     di,BEGTEXT              ; DI BEGTEXT, AX NULLVAL, CX 0
        xchg    cx,ax                   ; DI BEGTEXT, CX NULLVAL, AX 0
        xchg    di,ax                   ; AX BEGTEXT, CX NULLVAL, DI 0
        mov     ds,ax
        cmp     [di],cx                 ; DS:DI should be 00CDh (INT 0)
       endif                    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        je      nullok                  ; if no NULL assignment detected

gotcha: mov     ax,offset nullass       ; report null pointer assignment
fatal:  mov     dx,cs                   ; _cstart_ error messages in CS
        mov     bl,255                  ; BL = return code (undefined)
        call    __fatal_runtime_error_  ; display DX:AX message and exit
        jmp     nullok                  ; debugger returned: normal exit

nullop: pop     ax                      ; trash unknown DS saved below
        sti                             ; point of no return, be nice
nullerr label   CSLABEL
        mov     ax,offset nullmsg       ; report INT division by zero
        jmp     fatal                   ; fatal error, inform debugger

null_f: push    ds                      ; an INT 0 in a spawned child is
        call    __GETDS                 ; chained to whatever old INT 0
        assume  ds:DGROUP               ; handler, i.e., not our problem
        cmp     _child,0
        je      nullop                  ; no child => report fatal error
        push    sp                      ; make room for old INT 0 offset
        push    bp                      ; save child BP
        mov     bp,sp                   ; keep child DS in [BP+4]
        push    bx                      ; save child BX
        lds     bx,dword ptr __int0_AMIS + 2
        assume  ds:nothing
        mov     word ptr [bp+2],bx      ; old INT 0 offset
        mov     bx,ds                   ; old INT 0 segment
        xchg    word ptr [bp+4],bx
        mov     ds,bx                   ; restore child DS
        pop     bx                      ; restore child BX
        pop     bp                      ; restore child BP
        retf                            ; chain to old INT 0 with a RETF

__do_exit_with_msg__:
        public  __do_exit_with_msg__    ; expect input BL and DX:AX
        mov     di,offset _end+128
        and     di,1111111111111110b    ; word alignment for stack
        mov     cx,CSGROUP              ; DGROUP is CS for __TINY__
        mov     ss,cx                   ; SS = DGROUP
        mov     sp,di                   ; force good stack pointer
        push    cs
        pop     ds                      ; DS = code segment for devcon
        mov     es,dx                   ; ES = segment of message
        assume  ds:_TEXT, es:nothing, ss:DGROUP
        push    bx                      ; BL = return code
        push    ax                      ; DX:AX = far message pointer
        push    dx                      ; DX:AX and BL saved
        mov     dx,offset devcon        ; DS:DX ASCIIZ "\dev\con"
        mov     ax,3D01h                ; write-only access to screen
        int     21h                     ; AX handle for "\dev\con"
        jnc     usecon                  ; if no handle try STDERR:
        mov     ax,2                    ; AX 2 STDERR
usecon: xchg    ax,bx                   ; BX handle (CON: or STDERR)
        assume  ds:nothing              ; DS = segment of message
        pop     ds                      ; restore address of msg
        pop     dx                      ; DS:DX = far message pointer
        mov     di,dx                   ; ES:DI = DS:DX
        xor     ax,ax
        mov     cx,-1
        cld                             ; direction for string length
        repnz   scasb                   ; find string NUL terminator
        not     cx                      ; string length (excl. NUL)
        mov     ah,40h                  ; write string DS:DX
        int     21h
        pop     bx                      ; BL = return code

nullok: push    bx                      ; let __FiniRtns modify BX
        call    __GETDS                 ; DGROUP is CS for __TINY__
        assume  ds:DGROUP
       ifdef    OVERLAY         ;;;;;;; MEDIUM / LARGE / HUGE overlays ;;
        cmp     byte ptr __ovlflag,0    ; if MS Overlay Manager present
        je      no_ovl                  ; then
        mov     al,__intno              ; - get interrupt number used
        mov     ah,25h                  ; - DOS func to set interrupt vector
        lds     dx,__ovlvec             ; - get previous contents of vector
        int     21h                     ; - restore interrupt vector
       endif                    ;;;;;;; code WAS used for ALL models ;;;;
no_ovl: call    nullfin                 ; reset INT 0 if necessary
        xor     ax,ax                   ; run finalizers
        mov     dx,000Fh                ; less than exit
        call    __FiniRtns              ; do finalization
        pop     ax                      ; AL = return code
        mov     ah,4Ch                  ; back to DOS
        int     21h

devcon  db      '\dev\con',0            ; AVAILDEV compatible "con"
enomem  db      13,10,'Not enough memory',7,13,10,0
nullass db      13,10,'The Open Watcom C/C++16 Run-Time system'
        db      ' detected a NULL pointer assignment',7,13,10,0
nullmsg db      13,10,'Division by zero or NULL pointer call',7,13,10,0
__exit  endp

;-----------------------------------------------------------------------;
; __GETDS considerations:                                               ;
;       The code shown below does not work for 8088 or 8086 processors, ;
;       but this is already the case for the various "shift immediate"  ;
;       instructions used elsewhere.                                    ;
;-----------------------------------------------------------------------;

__GETDS proc    near                    ; near call in all memory models
        public  __GETDS
        assume  ss:nothing              ; cannot use "push ss", "pop ds"
       ifdef    __SW_0r                 ; 8088 / 8086 code:
        push    cx
        mov     cx,CSGROUP              ; DGROUP is CS for __TINY__
        mov     ds,cx
        pop     cx
       else                             ; 80186 (or better) code:
        push    CSGROUP                 ; unlike "mov ds,cs:[saved_ds]"
        pop     ds                      ; this can work in ROM programs
       endif
        ret
__GETDS endp

;-----------------------------------------------------------------------;
; INT 0 handler                                                         ;
;       Handler for integer division by zero, not for SIGFPE.  The real ;
;       entry point is at __int0_AMIS with a "magic" offset para + 0Dh. ;
;       The header follows IBM's Interrupt Sharing Protocol to a degree ;
;       needed for AMIS compatibility, i.e., a short jump is followed   ;
;       by the old INT 0 vector and a "KB" signature.                   ;
;                                                                       ;
;       The installed INT 0 handler triggers a __fatal_runtime_error_   ;
;       as for any detected NULL pointer call or assignment.  This will ;
;       terminate the program after informing a debugger if present.    ;
;                                                                       ;
;       For EXE-files the INT 0 handler is kept in the _NULL 'BEGDATA'  ;
;       segment (see above).  For COM-files it is defined below.  The   ;
;       old INT 0 address and the far jump to null_f are determined by  ;
;       nullini at runtime.                                             ;
;-----------------------------------------------------------------------;

       ifdef    __TINY__        ;;;;;;; same as _NULL segment __int0_AMIS
ADJUST  =       $
        align   16                      ; paragraph alignment for xxx0h
        org     $ + 0Dh                 ; get "magic" offset para + 0Dh
ADJUST  =       $ - ADJUST
        org     $ - ADJUST              ; back to start for fine tuning:
       if       ADJUST mod 16           ;      rept     ADJUST mod 16
        db      ADJUST mod 16 dup (0CCh);       int     3
       endif                            ;      endm
        assume  nothing                 ; CS != _TEXT set up by nullini
__int0_AMIS     label CSLABEL           ; Interrupt Sharing Protocol:
        jmp     short null_s            ;       short jump to ISR code
        dd      0                       ;       saved old INT 00h vector
        db      "KB",0,0EBh,0,0CBh      ;       "KB" protocol signature
null_s: db      0EAh                    ; CS = _TEXT set by a far jump
        dd      offset null_f           ; segment fixup done by nullini
        assume  cs:_TEXT
       endif                    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;-----------------------------------------------------------------------;
; INT 0 installation                                                    ;
;       The INT 0 handler is not automatically installed if any "exec"  ;
;       function is used, and a hack tricking "doexec" to reset the old ;
;       INT 0 handler is only available in C libraries without OVERLAY  ;
;       startup support.                                                ;
;                                                                       ;
;       ___Exec_addr is NULL after __InitRtns if no "exec" function is  ;
;       linked.  In this case INT 0 can be modified, because all other  ;
;       exits go through __exit and can restore INT 00h.  Otherwise all ;
;       "exec" functions call __doexec like all "spawn" functions call  ;
;       __dospawn.  Both __doexec and __dospawn call __close_ovl_file.  ;
;                                                                       ;
;       If OVERLAY is not a defined symbol __close_ovl_file is supposed ;
;       to be the pointer to a dummy RETF initialized by _cstart_, and  ;
;       nullini can modify this pointer to the INT 0 restore procedure  ;
;       nullfar.  The __dospwan and __doexec cases can be distinguished ;
;       with _child.  If __doexec fails INT 0 will be not re-installed. ;
;       A better solution requires modifications in __doexec, and maybe ;
;       also in signal() for a proper DOS SIGIDIVZ.                     ;
;                                                                       ;
;       If OVERLAY is defined __close_ovl_file cannot be abused, and if ;
;       ___Exec_addr is not NULL INT 0 will not be installed here.  The ;
;       public __int0_install_ function allows a "manual" installation. ;
;       Installing INT 0 twice in a row (without restore) causes havoc. ;
;                                                                       ;
;       If installed the new INT 00h address has the form ssss:xxxDh.   ;
;       This can be rewritten into a segment ssssh + 0xxxh - 000Ch with ;
;       offset 00CDh resulting in a vector CD00zzyyh at offset 0 of the ;
;       interrupt vector table.  An erroneous call 0000:0000 would then ;
;       interpret the offset CD 00 as code triggering INT 00h.  This is ;
;       the __int0_AMIS handler exiting with a __fatal_runtime_error_.  ;
;-----------------------------------------------------------------------;

__int0_install_ proc                    ; public nullini wrapper
        call    nullini                 ; in near code models this could
        ret                             ; be replaced by a near label...
__int0_install_ endp
nullini proc    near                    ; AX, BX, CX, and DX destroyed
        push    ds                      ; segment registers + DI saved
        push    es                      ; (as required BP is preserved)
        push    di
        call    __GETDS                 ; DGROUP is CS for __TINY__
        assume  ds:DGROUP, es:nothing
        mov     cx,word ptr ___Exec_addr+0
       ifidn    CSLABEL,far     ;;;;;;; check dword in far models ;;;;;;;
        or      cx,word ptr ___Exec_addr+2
       endif                    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        mov     ax,3500h                ; fetch interrupt vector 00h
        int     21h                     ; ES:BX = old INT 0 address
        mov     di,offset __int0_AMIS   ; DS:DI new INT 00h handler
        mov     [di+2],bx               ; saves old INT 00h offset
        mov     [di+4],es               ; saves old INT 00h segment
        mov     word ptr null_s+3,cs    ; CS segment fixup in far jump
        jcxz    grabit                  ; "exec" not linked, good
       ifdef    OVERLAY         ;;;;;;; OVERLAY and "exec" won't do ;;;;;
        jmp     short nullex            ; do not install INT 00h handler
       else
        mov     bx,offset nullfar       ; trick __doexec into restoring
        mov     __close_ovl_file+0,bx   ; the old INT 00h when it tries
        mov     __close_ovl_file+2,cs   ; to close a non-existing OVERLAY
       endif                    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
grabit: mov     bx,ds                   ; BX:DI new INT 00h handler
       ifdef    __SW_0r                 ; 8088 / 8086 code:
        mov     cl,4
        shr     di,cl                   ; extract 0xxxh from offset xxxDh
       else                             ; 80186 (or better) code:
        shr     di,4                    ; extract 0xxxh from offset xxxDh
       endif
        lea     di,[bx+di-12]           ; determine ssssh + 0xxxh - 000Ch
        mov     dx,00CDh                ; use offset DL = CDh, DH = 00h
        mov     ds,di                   ; DS:DX with "embedded" INT 00h
        assume  ds:nothing
        mov     ah,25h                  ; AX 3500h (get) to 2500h (set)
        int     21h                     ; users "may" now call 0000:0000
nullex: pop     di
        pop     es
        pop     ds
        ret
nullini endp

;-----------------------------------------------------------------------;
; INT 0 restauration                                                    ;
;       INT 0 is simply always restored, even if it was never modified. ;
;       INT 0 was modified after __InitRtns if at all, therefore it has ;
;       to be restored before __FiniRtns.                               ;
;                                                                       ;
;       The INT 0 handler can be "manually" uninstalled by calling the  ;
;       exported __int0_restore_ (or with any AMIS interrupt uninstall  ;
;       routine for the public __int0_AMIS header).                     ;
;-----------------------------------------------------------------------;

__int0_restore_ proc                    ; public nullfin wrapper
        call    nullfin                 ; in near code models this could
        ret                             ; be replaced by a near label...
__int0_restore_ endp
nullfin proc    near                    ; AX and DX destroyed, DS saved:
        push    ds                      ; __doexec does not expect that
        call    __GETDS                 ; AX and DX are preserved here
        assume  ds:DGROUP               ; DGROUP is CS for __TINY__
        lds     dx,dword ptr __int0_AMIS + 2
        assume  ds:nothing
        mov     ax,2500h                ; DS:DX old INT 00h address
        int     21h                     ; reset old INT 00h handler
        pop     ds
        ret
nullfin endp

        public  __int0_AMIS             ; public to build AMIS "muxlist"
        public  __int0_install_         ; (re-) install a "magic" INT 0
        public  __int0_restore_         ; restore the old INT 0 handler

nullfar proc    far                     ; __doexec expects a proc far in
        push    ds                      ; the dword ptr __close_ovl_file
        call    __GETDS                 ; DGROUP is CS for __TINY__
        assume  ds:DGROUP
        cmp     _child,0                ; __dospawn sets _child = 1, and
        jne     farend                  ; should not reset the old INT 0
        call    nullfin                 ; no child (exec): restore INT 0
farend: pop     ds                      ; if child (spawn) do nothing
        assume  ds:nothing
dummy   label   far                     ; RETF shared by a dummy handler
        retf
nullfar endp

_TEXT   ends
        end     _cstart_
