;-----------------------------------------------------------------------
; EAT.ASM source for EAT.EXE program: MASM EAT, LINK EAT
;-----------------------------------------------------------------------

	 assume cs:code, ds:data, es:data, ss:stack

data	 segment para public 'DATA'

execpar  dw	(?)		;segment environment
	 dd	offset noop	;pointer command line
	 dd	0		;no FCB for subshell
	 dd	0		;no FCB for subshell

argsptr  dd	80h		;pointer DTA arguments
commptr  dd	offset command	;default: \COMMAND.COM

switch	 dw	'/\'            ;DOS path characters
noop	 db	0,13		;empty argument line

free	 dw	(?)		;biggest free block segment

neat	 dw	-1		;paragraphs to be allocated
mode	 db	4		;0..3: F,B,L,- (-1 default)

comspec  db	'COMSPEC='      ;search COMSPEC text
command  db	'\COMMAND.COM',0

;-----------------------------------------------------------------------
;	 usage and other messages

nularg	 db	13
  db 10,10,'Sizes shown include 1 paragraph overhead per memory block.'
  db 13,10,'To determine subshell size call EAT after EAT [-]<number>.'
  db 13,10,0

usage	 db	13,10,'EAT.EXE, copyright (C) 1991 by Frank Ellermann',13
  db 10,10,'Usage: EAT [ F | B | L | - ] [ <number> ]',13
  db 10,10,'Use EAT to allocate a given <number> of memory paragraphs,'
  db 13,10,'i.e. pieces of 16 bytes.  Call EAT with - before <number>'
  db 13,10,'to create a "memory hole" of given size.',13
  db 10,10,'After memory allocation EAT enters a COMMAND.COM subshell'
  db 13,10,'and allows program tests under controlled free memory con-'
  db 13,10,'ditions.  Release allocated memory and leave EAT subshell'
  db 13,10,'with EXIT.',0

strtext  db	13,10,10,'DOS allocates memory blocks using the ',0
first	 db	'First',0
best	 db	'Best',0
last	 db	'Last',0
usend	 db	'EAT F, B or L sets global First, Best, Last'
fittext  db	' fit strategy.',13,10,0

owntext  db	13,10,'Used for EAT execution ',0
maxtext  db	13,10,'Max. free memory block ',0
memtext  db	13,10,'Total free memory rest ',0
envtext  db	13,10,'Actual EAT environment ',0
eattext  db	13,10,'EAT in max. free block ',0
paralen  db	'    ? * 16 =      ? bytes (  ? KB)',0
parasrc  db	'    ? * 16 =      ? bytes (  ? KB)',0

exittext db	13,10,7,'program return code ',0
exitcode db	'xxxxh',13,10,0

badarg	 db	13,10,7,'EAT expects argument [F|B|L|-][<0..40959>]'
	 db	' or no argument for help',13,10,0

baddos	 db	13,10,7,'EAT cannot set strategy',0
badmem	 db	13,10,7,'EAT cannot modify memory',0
badcom	 db	13,10,7,'EAT cannot find subshell',0
badexe	 db	13,10,7,'EAT cannot load subshell',0

exectext db	' - DOS return code ',0
execcode db	'xxxxh',0
code7	 db	' ( memory management )',13,10,0
code8	 db	' ( not enough memory )';13,10,0
crlf	 db	13,10,0

data	 ends

;-----------------------------------------------------------------------
code	 segment para public 'CODE'

main	 proc	far		;program entry point

	 mov	ax,data 	;install data segment DS
	 mov	ds,ax

	 mov	bx,ss		;SS:SP at end of program
	 mov	ax,es		;ES:0000h at program PSP
	 sub	bx,ax		;paragraph size segments
	 mov	cl,4
	 mov	ax,sp		;offset to stack pointer
	 shr	ax,cl		;converted to paragraphs
	 add	bx,ax		;paragraph size w/ stack
	 mov	cx,bx		;keep own memory size CX

	 mov	ah,4Ah		;modify allocated memory to
	 int	21h		;needed size i.e. free rest
	 jnc	envir		;carry flag memory error
	 jmp	memerr

;-----------------------------------------------------------------------
;	 note environment, determine own memory, check argument

envir:	 mov	bx,2Ch		;PSP offset 2Ch environment
	 mov	bx,es:[bx]	;own environmemt segment BX
	 mov	word ptr commptr+2,bx
	 mov	word ptr execpar+0,bx
	 mov	word ptr execpar+4,ds
	 mov	word ptr argsptr+2,es
	 push	ds		;ES = DS = data segment
	 pop	es

	 inc	cx		;inclusive overhead
	 xchg	ax,cx		;convert own memory
	 call	ax2para

	 mov	ax,3700h
	 int	21h		;get switch character:
	 mov	ax,switch	;if switch character '/'
	 jc	testarg 	;then path character '\'
	 cmp	dl,ah		;else path character '/'
	 jz	testarg
	 mov	al,ah
	 mov	ah,dl
	 mov	switch,ax	;path & switch character

testarg: lds	si,argsptr	;source DS:SI arguments
	 lodsb
	 cbw			;byte 1: size to word
	 mov	cx,ax		;size argument string
	 call	white		;skip control & blank
	 jcxz	noarg		;any character left ?

	 mov	al,byte ptr es:[switch+1]
	 mov	ah,'?'          ;switch + '?' ('/?')
	 cmp	[si],ax
	 je	noarg		;caller needs help !

	 lodsb			;lower case -,L,B,F
	 or	al,' '          ;mode -1 or 3,2,1,0
	 mov	ah,al
	 mov	al,3		;3 create memory hole
	 cmp	ah,'-'
	 jz	gotmode
	 dec	ax		;2 Last  fit strategy
	 cmp	ah,'l'
	 jz	gotmode
	 dec	ax		;1 Best  fit strategy
	 cmp	ah,'b'
	 jz	gotmode
	 dec	ax		;0 First fit strategy
	 cmp	ah,'f'
	 jz	gotmode
	 dec	ax		;-1 normal EAT memory
	 dec	si		;probably first digit

gotmode: mov	es:mode,al	;mode -1 or 3,2,1,0
	 call	white
	 jcxz	nosize		;no size maybe legal

	 call	atou		;convert to binary BX
	 lahf
	 call	white		;skip trailing blanks
	 sahf
	 push	es		;ES = DS = data segment
	 pop	ds
	 mov	neat,bx 	;BX paragraphs to EAT
	 jc	argerr		;overflow / non-digit
	 jcxz	noextra 	;got extra argument ?

argerr:  mov	dx,offset badarg
	 mov	al,87		;invalid parameter
	 jmp	exitmsg

nosize:  push	es		;ES = DS = data segment
	 pop	ds
	 cmp	mode,3		;only set strategy ?
	 ja	argerr		;no size okay if 0,1,2
	 jnz	noextra 	;& for simple syntax 3

noarg:	 push	es		;ES = DS = data segment
	 pop	ds
	 mov	dx,offset usage ;tell how to use EAT &
	 call	message 	;allocation strategy &
	 call	showstra	;finish usage message
	 mov	dx,offset usend
	 call	message 	;continue with memory

;-----------------------------------------------------------------------
;	 determine size max. free,  EATen fragmented, environment blocks

noextra: mov	dx,offset owntext
	 call	showtext

	 mov	bx,-1
	 mov	ah,48h		;reserve max. block
	 int	21h		;of 1 MB = get size
	 jnc	memerr		;okay !?

	 mov	cx,bx		;CX size max. block
	 inc	cx		;inclusive overhead
	 mov	ah,48h		;reserve max. block
	 int	21h		;max. segment begin
	 jc	memerr		;fail ??

	 mov	free,ax 	;note segment begin
	 xchg	ax,cx		;convert max memory
	 call	ax2para
	 mov	dx,offset maxtext
	 call	showtext
	 xor	cx,cx		;fragmented counter

reserve: mov	bx,-1		;allocate all holes:
	 mov	ah,48h		;reserve max. block
	 int	21h		;of 1 MB = get size
	 jnc	memerr		;okay !?

	 add	cx,bx		;fragment paragraphs
	 inc	cx		;inclusive overhead
	 mov	ah,48h		;reserve max. block
	 int	21h
	 jnc	reserve

	 dec	cx		;fragmented counter
	 xchg	ax,cx		;convert fragmented
	 call	ax2para
	 mov	dx,offset memtext
	 call	showtext

	 mov	es,execpar	;actual environment
	 mov	bx,-1
	 mov	ah,4Ah		;modify environment
	 int	21h		;to 1 MB = get size
	 jnc	memerr		;okay !?

	 push	ds		;ES = DS = data segment
	 pop	es
	 inc	bx		;inclusive overhead
	 xchg	ax,bx		;convert environment
	 call	ax2para
	 mov	dx,offset envtext
	 call	showtext

	 mov	es,free
	 mov	ah,49h		;release max. block
	 int	21h		;not necessary last <<-- don't forget it
	 jnc	cosa		;fail ??

memerr:  push	ds		;ES = DS = data segment
	 pop	es
	 mov	dx,offset badmem
	 call	message
	 jmp	doserr		;exit with AL error

;-----------------------------------------------------------------------
;	 set memory allocation strategy, find subshell

cosa:	 push	ds		;ES = DS = data segment
	 pop	es

	 xor	bx,bx
	 mov	bl,mode
	 cmp	bl,2		;strategy 0, 1, 2
	 ja	nostra		;3, 4: EAT only ?

	 mov	ax,5801h	;set new strategy
	 int	21h		;indicating error
	 jc	noserr

nostra:  cmp	neat,-1 	;only a demonstration
	 jz	usexit		;or only set strategy ?

	 call	compath
	 jnc	eatmem		;got COMMAND.COM path ?

	 mov	dx,offset badcom
	 call	message 	;COMMAND.COM not found
	 jmp	doserr		;exit with AL error

usexit:  cmp	mode,2		;only a demonstration
	 ja	nulexit 	;or only set strategy ?

	 call	showstra	;show (new) strategy
	 mov	al,0
	 jmp	exitnul 	;exit 0 strategy only

nulexit: mov	al,0		;exit 0 for EAT usage
	 mov	dx,offset nularg
	 jmp	exitmsg 	;show last usage text

noserr:  mov	dx,offset baddos
	 call	message
	 jmp	doserr		;exit with AL error

eaterr:  jmp	memerr		;this isn't funny !

;-----------------------------------------------------------------------
;	 eat memory and enter subshell (size to eat given)

eatmem:  mov	ax,neat 	;convert size to EAT
	 call	ax2para
	 mov	dx,offset crlf
	 call	message
	 mov	dx,offset eattext
	 call	showtext	;show size EAT bytes
	 call	showstra	;show (new) strategy

	 mov	bx,neat 	;paragraphs to EAT
	 sub	bx,1		;exclusive overhead
	 jc	exec		;don't EAT nothing

	 mov	ah,48h
	 int	21h		;EAT BX paragraphs
	 jc	eaterr

	 cmp	mode,3		;EAT memory hole ?
	 jnz	exec

	 mov	es,ax		;keep hole segment
	 mov	bx,neat
	 mov	ah,4Ah
	 int	21h		;increase overhead
	 jc	eaterr

	 xor	bx,bx		;get empty block
	 mov	ah,48h		;after allocated
	 int	21h		;memory block ES
	 jc	eaterr

	 mov	ah,49h		;release block ES
	 int	21h		;creates the hole
	 jc	eaterr

;-----------------------------------------------------------------------
;	 execute command (here subshell without argument)

exec:	 push	ds		;ES = DS = data segment
	 pop	es
	 push	ds		;save DS, ES, SS, SP
	 push	es
	 mov	bx,offset execpar
	 lds	dx,commptr	;DS:DX ASCIIZ command
	 mov	cs:savess,ss	;ES:BX exec parameter
	 mov	cs:savesp,sp
	 mov	ax,4B00h	;DOS exec function in
	 int	21h		;DOS 2.x destroys all
	 cli			;--------------------
	 mov	ss,cs:savess	;no interrupts during
	 mov	sp,cs:savesp	;restauration SS:SP
	 sti			;--------------------
	 pop	es		;restauration ES = DS
	 pop	ds

	 jc	execerr 	;no carry: exec done

	 mov	ah,4Dh		;get exit code from child
	 int	21h
	 or	ax,ax		;don't show return code 0
	 jz	exitnul

	 mov	dx,offset exittext
	 call	message
	 mov	di,offset exitcode
	 mov	dx,di
	 call	x2c		;convert hex. to ASCII
	 jmp	short exitmsg

savesp	 dw	(?)		;DOS 2.x exec can destroy SP
savess	 dw	(?)		;DOS 2.x exec can destroy SS

;-----------------------------------------------------------------------
;	 common exit handling

execerr: mov	dx,offset badexe
	 call	message

doserr:  mov	dx,offset exectext
	 call	message
	 mov	di,offset execcode
	 mov	dx,di
	 call	x2c		;convert hex. to ASCII
	 call	message
	 mov	dx,offset code7 ;memory management error
	 cmp	al,7
	 jz	exitmsg
	 mov	dx,offset code8 ;not enough free memory
	 cmp	al,8
	 jz	exitmsg
	 mov	dx,offset crlf	;other error codes

exitmsg: call	message 	;ASCIIZ DS:DX to STDERR, keep AL
exitnul: mov	ah,4Ch		;terminating with return code AL
	 int	21h

main	 endp

;-----------------------------------------------------------------------
showtext proc	near		;message DS:DX before message paralen

	 call	message 	;modifies BX, CX, DX
	 push	es		;keep AX, DI, ES
	 push	di
	 mov	dx,offset paralen
	 call	message
	 xchg	ax,bx		;keeping AX
	 push	ds
	 pop	es		;setting ES = DS
	 mov	di,dx		;copy target paralen
	 mov	dx,offset parasrc
	 call	strlen		;from source parasrc
	 xchg	si,dx
	 rep	movsb
	 xchg	si,dx		;restore SI
	 xchg	ax,bx		;restore AX
	 pop	di		;restore DI
	 pop	es		;restore ES
	 ret

showtext endp

;-----------------------------------------------------------------------
showstra proc	near		;message First, Best, Last fit strategy

	 mov	dx,offset strtext
	 call	message 	;modifies AX, BX, CX, DX

	 mov	ax,5800h
	 int	21h		;get allocation strategy
	 jc	stra1st 	;ignore error or AX > 2:

	 mov	dx,offset best
	 dec	ax		;1 Best  fit
	 jz	stratxt
	 mov	dx,offset last
	 dec	ax		;2 Last  fit
	 jz	stratxt

stra1st: mov	dx,offset first ;0 First fit or error
stratxt: call	message
	 mov	dx,offset fittext
	 call	message
	 ret

showstra endp

;-----------------------------------------------------------------------
ax2para  proc	near		;convert AX paragraphs to string paralen

	 push	ax		;modifies AX, CX, DX, DI
	 xor	dx,dx
	 mov	di,offset paralen+04
	 call	u2c		;convert DX:AX paragraphs
	 pop	ax

	 push	ax
	 mov	cx,16		;paragraphs AX to DX:AX bytes
	 mul	cx		;(assume DX:AX < 655360 bytes)
	 mov	di,offset paralen+18
	 call	u2c		;convert DX:AX bytes
	 pop	ax

	 mov	cl,6		;shl  4: AX * 16 bytes
	 shr	ax,cl		;shr 10: AX / 1024 KB
	 adc	ax,dx		;+ carry + 0 DX by u2c
	 mov	di,offset paralen+29
	 call	u2c		;convert DX:AX KB
	 ret

ax2para  endp

;-----------------------------------------------------------------------
compath  proc	near		;search COMSPEC in environment segment

	 push	ds		;modifies AX, CX, DI, SI
	 xor	ax,ax
	 mov	ds,word ptr commptr+2
	 mov	si,ax		;DS:SI start environment

scanit:  mov	cx,4
	 mov	di,offset comspec
	 repe	cmpsw		;look for 'COMSPEC='
	 mov	cx,si		;terminate search at segment limit
	 not	cx		;this will work for length < 64 KB
	 jne	skipit		;CMPSW NOT changed got 'COMSPEC='

gotspec: call	white		;skip white space after  '='
	 mov	dx,si		;do not patch path character
	 mov	ax,4300h	;check existence COMMAND.COM
	 int	21h
	 jc	envend

	 pop	ds		;restore own data segment
	 mov	word ptr commptr,si
	 ret			;no carry: good COMMAND.COM

skipit:  lodsb			;look for terminating NUL byte
	 or	al,al
	 loopnz skipit
	 jcxz	envend		;environment segment > 64 KB ?

	 cmp	[si],al 	;go on with search
	 jne	scanit		;unless double NUL

envend:  pop	ds		;restore own data segment
	 mov	al,byte ptr switch
	 mov	command,al	;replace default command
	 mov	word ptr commptr+2,ds
	 mov	dx,offset command
	 mov	ax,4300h	;trying default \COMMAND.COM
	 int	21h		;check existence COMMAND.COM
	 ret			;carry flag: bad COMMAND.COM

compath  endp

;-----------------------------------------------------------------------
white	 proc	near		;skip all characters <= blank at DS:SI

	 jcxz	empty		;modifies AL, address SI, length CX

blank:	 lodsb			;load DS:SI, and increment SI
	 cmp	al,' '
	 jnbe	black
	 loop	blank		;skip continues while CX > 0
empty:	 ret			;CX = 0 if no characters left

black:	 dec	si		;back SI to character > blank
	 ret			;CX > 0 means characters left

white	 endp

;-----------------------------------------------------------------------
strlen	 proc	near		;return length ASCIIZ string ES:DX

	 xchg	di,dx		;modifies AX, CX
	 mov	cx,di		;keep DX, DI, ES
	 not	cx		;terminate search at segment limit
	 push	di		;this will work for length < 64 KB
	 xor	al,al
	 repne	scasb		;search NUL
	 mov	cx,di		;DI points behind NUL (or is NULL)
	 pop	di		;restore DI
	 sub	cx,di		;length inclusive NUL
	 dec	cx		;length exclusive NUL
	 xchg	dx,di		;restore DX
	 ret			;returns CX string length

strlen	 endp

;-----------------------------------------------------------------------
message  proc	near		;ASCIIZ string DS:DX to STDERR

	 push	ax		;modifies BX, CX
	 push	es		;keep AX, DX, DS, ES
	 push	ds
	 pop	es		;set ES = DS
	 call	strlen		;CX = strlen( ES:DX )
	 pop	es		;load old ES

	 mov	bx,2		;ASCIIZ string DS:DX to STDERR
	 mov	ah,40h
	 int	21h
	 pop	ax
	 ret

message  endp

;-----------------------------------------------------------------------
atou	 proc	near		;CX ASCII DS:SI to unsigned BX 0..65229

	 xor	ax,ax		;modifies AX, CX, DX, SI
	 xor	bx,bx		;assume no leading space
	 jcxz	retcf		;no digit at all illegal

nextc:	 lodsb			;load digit / termination
	 cmp	al,'!'
	 jb	retbx		;ASCII number termination < '!'
;;;;;;;; cmp	bx,6552
	 cmp	bx,4095 	;SPECIAL FOR EAT: 0..40959 okay
	 jnbe	retcf		;reject overflow (0..65529 okay)
	 sub	al,'0'
	 jb	retcf		;reject non-digit < '0'
	 mov	dx,10
	 cmp	ax,dx
	 jnb	retcf		;reject non-digit > '9'
	 xchg	ax,bx
	 mul	dx		;old result BX * 10
	 xchg	ax,bx
	 add	bx,ax		;new result BX + AX
	 loop	nextc
	 ret

retcf:	 clc			;if carry: overflow or non-digit
retbx:	 cmc			;no carry: BX = converted binary
	 dec	si		;CX unconverted characters DS:SI
	 ret

atou	 endp

;-----------------------------------------------------------------------
u2c	 proc	near		;DX:AX < 655360 to ASCII right end DS:DI

	 mov	cx,10		;modifies AX, CX, DX, DI

reverse: div	cx
	 add	dl,'0'          ;digit DL to ASCII
	 mov	[di],dl 	;store it in DS:DI
	 dec	di		;run right to left
	 xor	dx,dx
	 cmp	ax,dx		;repeat conversion
	 jnz	reverse 	;until DX = AX = 0

	 ret			;DI before left end

u2c	 endp

;-----------------------------------------------------------------------
x2c	 proc	near		;convert word AX to ASCII at ES:DI

	 push	cx		;modifies DI
	 mov	cx,404h 	;keep AX, CX

anibble: rol	ax,cl		;roll next AX nibble (4 bits)
	 push	ax

	 and	al,0Fh		;( conversion invented by Tim Lopez )
	 cmp	al,10		;0..9  C; -6A 96..9F  A C; +AA 30..39
	 sbb	al,69h		;A..F NC; -69 A1..A6 NA C; +A0 41..46
	 das			;( NC (no) carry, NA (no) auxiliary )
	 stosb			;ASCII result

	 pop	ax
	 dec	ch		;for all 4 AX nibbles
	 jnz	anibble 	;after 4 roll nibbles AX is restored

	 pop	cx
	 ret

x2c	 endp
code	 ends

;-----------------------------------------------------------------------
stack	 segment para stack 'STACK'

	 dw	128 dup (?)	;stack size in words
	 align	16		;force paragraph end

stack	 ends
	 end	main		;program entry point
