;-----------------------------------------------------------------------
; ENVSIZE.ASM source for ENVSIZE.EXE program: MASM ENVSIZE, LINK ENVSIZE
;-----------------------------------------------------------------------

         assume cs:code, ds:data, es:data, ss:stack

data     segment para public 'DATA'

argsptr  dd     80h             ;pointer DTA arguments
envsize  dw     (?)             ;total environment block size

;-----------------------------------------------------------------------
;        usage and other messages

usage    db     13,10,'ENVSIZE.EXE, copyright (C) 1992 by F. Ellermann',13
  db 10,10,'ENVSIZE displays the total, used, and remaining size of'
  db 13,10,'the current DOS environment in bytes on STDERR.',13,10,0

doserror db     'DOS error '
coderror db     '00',13,10,0

badenv   db     'Bad loader environment',13,10,0

showenv  db     'Environment size',13,10,'total:      '
total    db     '  ',13,10,'used:       '
used     db     '  ',13,10,'rest:       '
rest     db     '  ',13,10,0

data     ends

;-----------------------------------------------------------------------
code     segment para public 'CODE'

main     proc   far             ;program entry point

         mov    ax,data         ;install data segment DS
         mov    ds,ax

         mov    bx,ss           ;SS:SP at end of program
         mov    ax,es           ;ES:0000h at program PSP
         sub    bx,ax           ;paragraph size segments
         mov    cl,4
         mov    ax,sp           ;offset to stack pointer
         shr    ax,cl           ;converted to paragraphs
         add    bx,ax           ;paragraph size w/ stack

         mov    ah,4Ah          ;modify allocated memory to
         int    21h             ;needed size i.e. free rest
         jnc    notepsp         ;carry flag memory error

doserr:  aam                    ;code AL 00..99 to AX 0000..0909
         or     coderror+0,ah
         or     coderror+1,al
         aad
         mov    dx,offset doserror
         jmp    exitmsg

;-----------------------------------------------------------------------
;        note PSP, evaluate argument

notepsp: mov    word ptr argsptr+2,es
         push   ds              ;ES = DS = data segment
         pop    es

         lds    si,argsptr      ;source DS:SI arguments
         lodsb
         cbw                    ;byte 1: size to word
         mov    cx,ax           ;size argument string
         call   white           ;skip control & blank
         push   es              ;ES = DS = data segment
         pop    ds
         jcxz   noarg           ;any character left ?

         mov    dx,offset usage ;tell usage and exit 87
         mov    al,87           ;invalid parameter code
         jmp    exitmsg

;-----------------------------------------------------------------------
;        determine environment of parent process

         assume es:nothing
noarg:   mov    es,word ptr argsptr+2   ;actual PSP
         mov    es,word ptr es:[16h]    ;loader PSP
         mov    bx,es
         mov    es,word ptr es:[2Ch]    ;loader environment

         push   es
         mov    ax,es
         dec    ax
         mov    es,ax                   ;header environment
         cmp    bx,word ptr es:[1]      ;owner = loader ?
         mov    ax,word ptr es:[3]      ;paragraphs
         pop    es

         jne    exitenv         ;modified owner ?
         test   ah,-16          ;length < 65521 ?
         jnz    exitenv         ;invalid length ?

         mov    cl,4            ;convert paragraphs
         shl    ax,cl           ;environment length
         mov    envsize,ax
         xor    di,di           ;variable pointer

;-----------------------------------------------------------------------
;        skip environment variables

nextvar: cmp    di,envsize      ;still inside environment ?
         jnb    exitenv
         cmp    byte ptr es:[di],0
         jz     endvar          ;double NUL last variable ?

         mov    dx,di
         call   strlen
         mov    bp,cx           ;variable length
         mov    di,dx           ;variable begin
         lea    di,[di+bp+1]    ;next after NUL
         jmp    nextvar

exitenv: push   ds              ;DS = ES = data segment
         pop    es
         mov    ax,10           ;invalid environment code
         mov    dx,offset badenv
         jmp    short exitmsg

;-----------------------------------------------------------------------
;        skip command path string

endvar:  cmp    word ptr es:[di+1],1
         jne    endenv          ;subshell may have no path

         lea    di,[di+3]       ;skip double NUL and 1
         mov    cx,-1
         xor    ax,ax
         repnz  scasb           ;skip command path
         jnz    exitenv

endenv:  inc    di              ;count terminating NUL
         cmp    di,envsize
         jnbe   exitenv

;-----------------------------------------------------------------------
;        display total and used size

         assume es:data
         push   ds              ;DS = ES = data segment
         pop    es
         mov    si,di           ;save used size in SI
         xor    dx,dx           ;DX:AX is converted...

         mov    di,offset total
         mov    ax,envsize
         call   u2c
         mov    di,offset used
         mov    ax,si
         call   u2c
         mov    di,offset rest
         mov    ax,envsize
         sub    ax,si
         call   u2c

         mov    dx,offset showenv
         xor    ax,ax           ;prepare exit code 0 (okay)

;-----------------------------------------------------------------------
;        common exit handling

exitmsg: call   message         ;ASCIIZ DS:DX to STDERR, keep AL
         mov    ah,4Ch          ;terminating with return code AL
         int    21h

main     endp

;-----------------------------------------------------------------------
white    proc   near            ;skip all characters <= blank at DS:SI

         jcxz   empty           ;modifies AL, address SI, length CX

blank:   lodsb                  ;load DS:SI, and increment SI
         cmp    al,' '
         jnbe   black
         loop   blank           ;skip continues while CX > 0
empty:   ret                    ;CX = 0 if no characters left

black:   dec    si              ;back SI to character > blank
         ret                    ;CX > 0 means characters left

white    endp

;-----------------------------------------------------------------------
strlen   proc   near            ;return length ASCIIZ string ES:DX

         xchg   di,dx           ;modifies AX, CX
         mov    cx,di           ;keep DX, DI, ES
         not    cx              ;terminate search at segment limit
         push   di              ;this will work for length < 64 KB
         xor    al,al
         repne  scasb           ;search NUL
         mov    cx,di           ;DI points behind NUL (or is NULL)
         pop    di              ;restore DI
         sub    cx,di           ;length inclusive NUL
         dec    cx              ;length exclusive NUL
         xchg   dx,di           ;restore DX
         ret                    ;returns CX string length

strlen   endp

;-----------------------------------------------------------------------
u2c      proc   near            ;DX:AX < 655360 to ASCII right end DS:DI

         mov    cx,10           ;modifies AX, CX, DX, DI

reverse: div    cx
         add    dl,'0'          ;digit DL to ASCII
         mov    [di],dl         ;store it in DS:DI
         dec    di              ;run right to left
         xor    dx,dx
         cmp    ax,dx           ;repeat conversion
         jnz    reverse         ;until DX = AX = 0

         ret                    ;DI before left end

u2c      endp

;-----------------------------------------------------------------------
message  proc   near            ;ASCIIZ string DS:DX to STDERR

         push   ax              ;modifies BX, CX
         push   es              ;keep AX, DX, DS, ES
         push   ds
         pop    es              ;set ES = DS
         call   strlen          ;CX = strlen( ES:DX )
         pop    es              ;load old ES

         mov    bx,2            ;ASCIIZ string DS:DX to STDERR
         mov    ah,40h
         int    21h
         pop    ax
         ret

message  endp

code     ends

;-----------------------------------------------------------------------
stack    segment para stack 'STACK'

         dw     128 dup (?)     ;stack size in words
         align  16              ;force paragraph end

stack    ends
         end    main            ;[7h (default ANSI.SYS console output)
