;-----------------------------------------------------------------------
; Installation: DEVICE=[<drive>:][<path>\]LOMEM.SYS
;-----------------------------------------------------------------------
; Creation: WASM -wx -we -q -3 -bt=DOS -mt LOMEM
;           WDIS -l -fi LOMEM
;           WLINK op q,map format dos com file LOMEM name LOMEM.SYS
; Untested: MASM LOMEM && LINK LOMEM && EXE2BIN LOMEM LOMEM.SYS
;-----------------------------------------------------------------------
; LOMEM.SYS is a fake HIMEM.SYS device installed before UMBPCI.SYS.
; It permits LH, DEVICEHIGH, INSTALLHIGH, and DOS=HIGH,UMB after
; UMBPCI.SYS created one or more UMBs.
;
; LOMEM.SYS ignores all installation parameters.  Notably /HMAMIN
; is not supported; the HMA should be only used for DOS=HIGH.
;
; Functions 16..18 return 80h (not implemented) if no UMB provider
; is installed after LOMEM.SYS.  Error codes are returned in BL with
; AX 0 (error).  Normally result AX 1 means okay (BL preserved), but
; for function 7 (query A20) BL 0 is okay with the A20 state in AX.
; For function 0 (query version) AX/BX are the XMS/driver versions.
;
; LOMEM.SYS does not manage XMS memory above the HMA.  XMS functions
; 8 and 9 return error A0h (no free XMS memory).  Functions 12..15
; return A2h (invalid XMS handle).  Function 11 (move block) returns
; A3h/A4h (invalid source/target handle), unless both handles are 0
; indicating "real" memory below 1 MB.  LOMEM.SYS uses interrupt 15h
; AH 87h for function 11 and does not enter protected mode.  IOW any
; protected mode processing is handled by interrupt 15h function 87h.
;
; When LOMEM.SYS is installed it tries to toggle the A20 line using
; port 92h.  If the A20 line cannot be modified the corresponding XMS
; functions 3..6 fail (error code 82h) and the HMA is unavailable
; (functions 1..2 error 90h).  Use DOS=LOW in "real mode" to test the
; XMS A20 and HMA functions.  Microsoft's HITEST.COM (vintage 1989)
; is fine for this purpose.
;
; LOMEM.SYS occupies 576/902 bytes after/for its installation.
;                                               (2010, Frank Ellermann)
;-----------------------------------------------------------------------

.errndef __TINY__               ;DOS device drivers are tiny (DS == CS)
         .386                   ;allow .386 instructions, e.g., "setne"
DGROUP   group  _TEXT
_TEXT    segment use16 para public 'CODE'
         assume nothing
         assume cs:DGROUP

DEVNAME  equ    "XMSXXXX0"      ;device name as for HIMEM.SYS
KBMAGIC  equ    "KB",0,0EBh,0,0CBh      ;see AMIS specification

CMD      equ    02              ;offset command
STATUS   equ    03              ;offset status code
BUFFER   equ    14              ;offset I/O buffer / device end address
CONFIG   equ    18              ;offset addr. init. string [BPB pointer]
INIERR   equ    23              ;offset addr. init. error flag (DOS 5+)

device   dd     -1              ;device link
         dw     8000h           ;attribute 15 character device
         dw     offset strategy ;device strategy  entry offset
         dw     offset intentry ;device interrupt entry offset
         db     DEVNAME         ;character device name

;-----------------------------------------------------------------------
new2Fh   proc   far
         jmp    short chk2Fh    ;this is actually a "KB" structure...
old2Fh   dd     0               ;far address old interrupt 2Fh
         db     KBMAGIC         ;"KB" AMIS specification 3.6 compatible

jmp2Fh:  jmp    cs:[old2Fh]
chk2Fh:  cmp    ax,4300h        ;XMS presence check
         jne    api2Fh
         or     al,80h
         iret

api2Fh:  cmp    ax,4310h        ;XMS API entry point
         jne    jmp2Fh
         push   cs
         pop    es
         mov    bx,offset xmsfake
         iret
new2Fh   endp

;-----------------------------------------------------------------------
; used XMS 2.0 error codes (BL) and function numbers (AH)

A20SET   equ    03h             ;fake XMS: A20  enable (owner)
A20CLR   equ    04h             ;fake XMS: A20 disable (owner)
A20STAT  equ    07h             ;fake XMS: A20 status
XMALLOC  equ    09h             ;fake XMS: allocate XMS memory
MEMMOVE  equ    0Bh             ;fake XMS: move DOS/XMS memory
UMALLOC  equ    10h             ;fake XMS: allocate UMB

BADFUNC  equ    080h            ;XMS code: unknown or not implemented
A20FAIL  equ    082h            ;XMS code: cannot modify A20 line
GENFAIL  equ    08Eh            ;XMS code: general failure
HMAFAIL  equ    090h            ;XMS code: HMA unavailable
HMAUSED  equ    091h            ;XMS code: no free HMA menory
HMAMINE  equ    092h            ;XMS code: HMAMIN prohibition
HMAFREE  equ    093h            ;XMS code: release HMA error
XMSUSED  equ    0A0h            ;XMS code: no free XMS memory
BADHAND  equ    0A2h            ;XMS code: invalid handle (A2..A4)
BADSIZE  equ    0A7h            ;XMS code: invalid length
OVERLAP  equ    0A8h            ;XMS code: source overlaps target
RAMFAIL  equ    0A9h            ;XMS code: RAM parity error

;-----------------------------------------------------------------------
xmsfake  proc   far
         jmp    short xmstart   ;\  / start with EB 03 90 90 90
         nop                    ; \/  as per XMS specification:
         nop                    ; /\  extensions can then patch
         nop                    ;/  \ a far jump EA ?? ?? ?? ??
xmstart: pushf
         cld
         cmp    ah,A20STAT
         jbe    a20func         ;functions 0..7

         mov    al,BADFUNC      ;unknown subfunction
         cmp    ah,UMALLOC      ; or not implemented
         jnb    xmsblot         ;functions 16..255

         mov    al,XMSUSED      ;no XMS memory available
         cmp    ah,XMALLOC
         jnb    xmsfunc         ;functions 9..15
         cwd                    ;size ext. mem. (XMS function 08)
xmsfunc: jbe    xmsblot         ;functions 8..9

         mov    al,BADHAND      ;invalid handle (there are no handles)
         cmp    ah,MEMMOVE      ;function 11
         jne    xmsblot         ;function 10 or 12..15 (BL = A2h)
         inc    ax              ;invalid source handle (BL = A3h)
         cmp    word ptr [si+04],0
         jne    xmsblot
         inc    ax              ;invalid target handle (BL = A4h)
         cmp    word ptr [si+10],0
         jne    xmsblot

         call   xmsmove         ;DS:SI = XMS move structure
         or     al,al
         jz     xmsokay
xmsblot: mov    bl,al           ;BL = error code
         jmp    short xmsfail

a20func: cli                    ;no interrupt until popf/retf
         push   ds
         push   bx
         push   cs
         pop    ds
         assume ds:DGROUP
         mov    bx,offset a20cmds
         mov    al,ah           ;AL = function 0..7
         xlat                   ;AL = offset -128..+127 \/ please check
         cbw                    ;AX = offset -128..+127 /\ XLAT a20cmds
         add    bx,ax           ;BX = offset of function 0..7
         mov    ax,word ptr hmabyte
         jmp    bx              ;AL = hmabyte, AH = a20byte

a20f00:  pop    bx              ;function 0: XMS version
         pop    ds              ;reset DS for function 0
         xor    dx,dx           ;0: HMA unavailable
         cmp    al,-1
         setne  dl              ;1: HMA exists
         mov    ax,0200h        ;XMS version 2.0
         mov    bx,4            ;LOMEM.SYS 0.4 (same as WINDUMB.SYS)
         jmp    short xmsexit

a20f01:  pop    bx              ;function 1: acquire HMA
         mov    ah,HMAUSED
         xor    al,1            ;AL 1 (free) to 0 (used)
         jnz    hmabad1         ;HMA used or unavailable
        ifdef   HMAMIN_SET      ;-----------------------------------
         mov    ah,HMAMINE
         cmp    dx,hmamin
         jb     hmabad2         ;HMAMIN prohibition
        endif                   ;-----------------------------------
hmaokay: mov    hmabyte,al
popokay: pop    ds              ;reset DS for functions 1..7 (okay)
xmsokay: mov    ax,1            ;AX 1: okay
xmsexit: popf
         retf

a20f02:  pop    bx              ;function 2: release HMA
         mov    ah,HMAFREE
         xor    al,1            ;AL 0 (used) to 1 (free)
         jz     hmabad2         ;HMA not allocated
         jns    hmaokay
hmabad1: jns    hmabad2
         mov    ah,HMAFAIL      ;HMA unavailable (-1)
hmabad2: mov    bl,ah
popfail: pop    ds              ;reset DS for functions 1..7 (fail)
xmsfail: xor    ax,ax
         popf
         retf

        ifdef   HMAMIN_SET      ;-----------------------------------
hmamin   dw     0               ;HMAMIN limit, set by init (not yet)
        endif                   ;-----------------------------------
hmabyte  db     1               ;1: free, 0: used, -1: bad \/ keep this
a20byte  db     0               ;A20 off, adjusted by init /\ together
a20cmds  db     offset a20f00 - offset a20cmds
         db     offset a20f01 - offset a20cmds
         db     offset a20f02 - offset a20cmds
         db     offset a20f03 - offset a20cmds
         db     offset a20f04 - offset a20cmds
         db     offset a20f05 - offset a20cmds
         db     offset a20f06 - offset a20cmds
         db     offset a20f07 - offset a20cmds

a20f03:  mov    ah,-1           ;function 3: A20 owner  enable
         jmp    short a20mod
a20f04:  mov    ah,0            ;function 4: A20 owner disable
         jmp    short a20mod
a20f05:  inc    ah              ;function 5: A20 local  enable
         jnz    a20mod
         jmp    short a20lim    ;undo  overflow
a20f06:  or     ah,ah           ;function 6: A20 local disable
         jz     a20mod          ;skip underflow
a20lim:  dec    ah

a20mod:  in     al,92h          ;port 92h A20 bit 1 in AL
         mov    bl,al           ;AH is intended A20 state
         or     al,2            ;set bit 1 (to enable A20)
         or     ah,ah           ;Z: disable A20 (wrap around)
         jnz    a20_on          ;NZ: enable A20 (use HMA)

         xor    al,2            ;clear bit 1 (disable A20)
         call   near a20chk
         jne    a20okay         ;wrap around is okay
a20bad:  pop    bx              ;BH of caller reset
         mov    bl,A20FAIL
         jmp    popfail

a20_on:  call   near a20chk
         jne    a20bad          ;wrap around is wrong
a20okay: mov    a20byte,ah
         pop    bx              ;BX of caller reset
         jmp    popokay

a20f07:  call   a20wrap         ;function 7: A20 status
         pop    bx              ;BH of caller reset
         mov    bl,0            ;BL 0: no error
         je     popokay         ;AX 1: A20 enabled
         jne    popfail         ;AX 0: wrap around

a20chk:  cmp    al,bl
         je     a20tst          ;skip if AL = BL
         out    92h,al
a20tst:  call   a20wrap
         retn                   ;near inline proc
xmsfake  endp

;-----------------------------------------------------------------------
         assume ds:nothing

a20wrap  proc   near            ;modifies BX, expects CLI
         push   es
         push   ds
         push   ax
         mov    bx,-1           ;ES = FFFFh
         mov    es,bx
         inc    bx              ;DS = 0000h
         mov    ds,bx
         mov    al,[bx]         ;get DS:[00h]
         mov    ah,es:[bx+10h]  ;get ES:[10h]
         not    byte ptr [bx]   ;new DS:[00h]
         cmp    ah,es:[bx+10h]
         mov    [bx],al         ;old DS:[00h]
         pop    ax
         pop    ds
         pop    es
         ret                    ;NE: A20 off, E: on
a20wrap  endp

;-----------------------------------------------------------------------
xmsmove  proc   near            ;DS:SI = XMS move structure
        ifndef  NO11            ;------ use int 15h to move block ------
         pusha
         push   es
         push   ds
         push   ss
         pop    es
         assume ds:nothing, es:nothing, ss:nothing

         mov    bp,sp           ;ES:BP = SS:SP
         mov    cx,48+8         ;48 for int 15h, +8 (2 dwords)
         sub    sp,cx           ;SS:SP alloca CX
         xor    ax,ax
         mov    di,sp           ;ES:DI alloca
         rep    stosb           ;clean alloca CX
         mov    di,sp           ;ES:DI alloca
         push   bp              ;store old SP

         mov    bp,48           ;DS:[SI+04] source handle 0
         mov    bx,6            ;DS:[SI+06] source seg:ofs
         call   near linear     ;ES:[DI+48] source linear
         mov    bp,52           ;DS:[SI+10] target handle 0
         mov    bx,12           ;DS:[SI+12] target seg:ofs
         call   near linear     ;ES:[DI+52] target linear

         mov    cx,[si+0]       ;= linear length low
         mov    bp,[si+2]       ;= linear length high
         push   ss
         pop    ds              ;DS = ES = SS (stack of caller)

         mov    ax,[di+48]      ;= linear source low
         mov    bx,[di+50]      ;= linear source high
         add    ax,cx           ;+ linear length low
         adc    bx,bp           ;+ linear length high
         jc     oddmove         ;lost bit, bad length
         shr    cx,1            ;length < 8000h words
         jc     oddmove         ;lost bit, bad length
         inc    bp              ;64 KB blocks + first
         jz     oddmove         ;lost bit, bad length

         mov    dx,[di+54]      ;= linear target high
         cmp    bx,dx           ;(src+len) ? dst high
         mov    bx,[di+52]      ;= linear target low
         jb     trymove         ;(src+len) < dst ok.
         ja     chkmove         ;(src+len> > dst unclear
         cmp    ax,bx           ;(src+len) ? dst low
         jna    trymove         ;(src+len) > dst unclear

chkmove: cmp    dx,[di+50]      ;target ? source high
         jb     trymove         ;target < source ok.
         ja     badmove         ;target > source bad
         cmp    bx,[di+48]      ;target ? source low
         ja     badmove         ;target > source bad

trymove: mov    si,di           ;ES:SI = int 15h table
         mov    di,93h          ;int 15h access rights
nxtmove: push   bp
         push   bx
         mov    bp,48           ;linear source
         mov    bx,16           ;int 15h table: source
         call   near setmove
         mov    bp,52           ;linear target
         mov    bx,24           ;int 15h table: target
         call   near setmove
         pop    bx
         pop    bp
         pushf                  ;-----------------------
         sti
         mov    ah,87h
         popf                   ;-----------------------
         int    15h             ;move block (AH 87h)
         cmp    ah,3
         je     a20move         ;A20 failure
         cmp    ah,1
         je     parmove         ;memory parity error
         ja     intmove         ;interrupted move (?)
         mov    cx,8000h        ;next 64 KB (words)
         dec    bp              ;rest 64 KB blocks
         jnz    nxtmove         ;next block

         pop    sp              ;undo alloca
         pop    ds
         pop    es
         popa
         mov    al,0            ;okay
         ret                    ;-----------------------
oddmove: pop    sp              ;undo alloca
         pop    ds
         pop    es
         popa
         mov    al,BADSIZE      ;odd or invalid length
         ret                    ;-----------------------
badmove: pop    sp              ;undo alloca
         pop    ds
         pop    es
         popa
         mov    al,OVERLAP      ;source overlaps target
         ret                    ;-----------------------
parmove: pop    sp              ;undo alloca
         pop    ds
         pop    es
         popa
         mov    al,RAMFAIL      ;move block parity error
         ret                    ;-----------------------
a20move: pop    sp              ;undo alloca
         pop    ds
         pop    es
         popa
         mov    al,A20FAIL      ;move block A20 failure
         ret                    ;-----------------------
intmove: pop    sp              ;undo alloca
         pop    ds
         pop    es
         popa
         mov    al,GENFAIL      ;move block interrupted
         ret                    ;-----------------------

setmove  label  near            ;SS = DS, src/dst [SI+BP]
         mov    ax,[si+bp+0]    ;= linear src/dst low
         mov    dx,[si+bp+2]    ;= linear src/dst high
         mov    word ptr [si+bx+0],-1   ;max. length 64 KB
         mov    [si+bx+2],ax    ;int 15h: src/dst low
         mov    [si+bx+4],dl    ;int 15h: src/dst high (DL)
         mov    [si+bx+5],di    ;int 15h: access rights
         mov    [si+bx+7],dh    ;int 15h: src/dst high (DH)
         add    ax,cx           ;+ linear length words
         adc    dx,0
         add    ax,cx           ;+ linear length bytes
         adc    dx,0
         mov    [si+bp+0],ax    ;set next src/dst low
         mov    [si+bp+2],dx    ;set next src/dst high
         retn                   ;near inline proc

linear   label  near            ;SS = ES, linear SS:[DI+BP]
         push   [si+bx+0]       ;src/dst offset
         pop    [di+bp+0]       ;linear address low start
         mov    ax,[si+bx+2]    ;src/dst segment
         rol    ax,4            ;4321 to 3214
         mov    bx,ax           ;3214 (example)
         and    bx,000Fh        ;0004 (segment bits 12..15)
         xor    ax,bx           ;3210 (16bit offset)
         add    [di+bp+0],ax    ;linear address low final
         adc    [di+bp+2],bx    ;linear address high
         retn                   ;near inline proc
        else                    ;---------------------------------------
         mov    bl,BADFUNC      ;32bit real memory move not implemented
         ret                    ;(only) this violates XMS specification
        endif                   ;---------------------------------------
xmsmove  endp

;-----------------------------------------------------------------------
strat0   proc   far
         mov    word ptr es:[bx+STATUS],810Ch   ;ready, general failure
entry0   label  far             ;after init reject further requests
         retf
strat0   endp

;-----------------------------------------------------------------------
ADJUST   =      $               ;fill paragraph with CCh (INT 3)
         align  10h             ;resident code end at paragraph
ADJUST   =      $ - ADJUST      ;new offset, align gap 00..0Fh
         org    $ - ADJUST      ;old offset, gap = gap mod 10h
        if      ADJUST mod 08h  ;fill gap to xxx8h or to xxx0h
         db     ADJUST mod 08h dup (0CCh)
        endif
        if      ADJUST mod 10h ge 8
         db     DEVNAME         ;upper gap from xxx8h to xxx0h
        endif

;------------------------------- non-resident section ------------------
; Serialization strategy:  Each request is initialized with status busy.
; If the old request offset is -1 (invalid) a new request can be noted.
; The request offset is invalidated (-1) at the begin of intentry.  If
; the request offset is invalid intentry exits.  A "running" semaphore
; is incremented at the start of intentry and decremented at exit.  The
; initial running value is -1 and permits intentry to process a request.

request  dd     -1              ;request block address pointer
running  db     -1

strategy proc   far
         pushf
         cli
         mov    word ptr es:[bx+STATUS],200h    ;status busy, not ready
         cmp    word ptr cs:request+0,-1        ;at most one request
         jne    intbusy
         mov    word ptr cs:request+0,bx        ;ES:BX is address...
         mov    word ptr cs:request+2,es        ;...of request block
intbusy: popf
         retf
strategy endp

;-----------------------------------------------------------------------
intentry proc   far
         pushf
         pusha                  ;save registers
         push   ds
         push   es
         cld
         push   cs
         pop    ds              ;data in code segment
         assume ds:DGROUP

         inc    byte ptr running
         jnz    intnop
         les    di,request      ;ES:DI request
         mov    si,-1           ;invalidate request
         cmp    si,di
         je     intnop          ;no pending request
         mov    word ptr request,si

         mov    ax,8003h        ;unknown cmd (8003h)
         cmp    byte ptr es:[di+CMD],0
         jne    intbad          ;support only init (0)
         mov    ax,8005h        ;invalid request size
         cmp    byte ptr es:[di],INIERR
         jbe    intbad          ;INIERR asserts DOS 5+
         call   init

intbad:  or     ah,1            ;status ready bit
         mov    es:[di+STATUS],ax
intnop:  dec    byte ptr running
         pop    es              ;restore registers
         pop    ds
         popa
         popf
         retf
intentry endp

;-----------------------------------------------------------------------
init     proc   near            ;device initialization
         inc    si              ;cheap 0
         mov    es:[di+BUFFER+0],si
         mov    es:[di+BUFFER+2],cs


         mov    si,offset device+6
         mov    [si+0],offset strat0
         mov    [si+2],offset entry0

         mov    ax,4300h        ;test XMS presence
         int    2Fh
         cmp    al,80h
         jne    initmux

         mov    dx,offset msgxms
         call   initmsg
         inc    byte ptr es:[di+INIERR]
         mov    ax,800Ch        ;general failure
         ret

initmux: push   es              ;---------------------------------
         mov    si,offset new2Fh
         mov    ax,352Fh        ;fetch ES:BX = address old handler
         int    21h
         mov    dx,si           ;DX     = SI =  offset new handler
         mov    [si+2],bx       ;[SI+2] = BX =  offset old handler
         mov    [si+4],es       ;[SI+4] = ES = segment old handler
         mov    ah,25h
         int    21h             ;install new int 2Fh handler DS:DX
         pop    es              ;---------------------------------

         mov    ah,A20STAT      ;XMS function 7: A20 status
         push   cs              ;\/ emulate far call without
         call   near xmsfake    ;/\ segment relocation
         mov    bx,A20SET + A20CLR * 256
         or     al,ah
         jz     initest         ;check enable + disable
         dec    a20byte         ;initialize enabled A20
         xchg   bh,bl           ;check disable + enable

initest: mov    ah,bl           ;XMS function 3: A20 enable
         push   cs              ;(or function 4 if swapped)
         call   near xmsfake
         or     ah,al
         jz     initnak
         mov    ah,bh           ;XMS function 4: A20 disable
         push   cs              ;(or function 3 if swapped)
         call   near xmsfake
         or     ah,al
         jz     initnak

         cmp    bl,bh
         jb     initack         ;enable + disable (okay)
         mov    dx,offset msga20
         call   initmsg         ;disable + enable (unusual)
         jmp    initack

initnak: neg    hmabyte         ;-1: HMA unavailable
         mov    dx,offset msghma
         call   initmsg

initack: xor    ax,ax           ;end of resident code:
         mov    es:[di+BUFFER+0],offset request
         ret                    ;AX = 0 (okay)
init     endp

;-----------------------------------------------------------------------
initmsg  proc   near
         mov    ah,9
         push   dx
         mov    dx,offset msgbeg
         int    21h
         pop    dx
         int    21h
         mov    dx,offset msgend
         int    21h
         ret
initmsg  endp

msgxms   db     "XMS already installed$"
msga20   db     "A20 line not disabled$"
msghma   db     "HMA unavailable$"

msgbeg   db     DEVNAME,": $"
msgend   db     13,10,"$"

;-----------------------------------------------------------------------
_TEXT    ends
         public request         ;public symbols for WDISasm listing
         public running         ;-1: inactive

         public new2Fh
         public old2Fh
         public xmsfake         ;XMS API entry point (HIMEM.SYS)
         public xmsmove         ;XMS function 11 (move block)
         public a20wrap         ;A20 line test (wrap around)

         public strategy        ;device request (stored in request)
         public intentry        ;devive interrupt (execute request)
         public strat0          ;after init: all requests rejected
         public entry0          ;after init: do nothing (resident)
         public init            ;used once (not resident)

         end    device
