;-----------------------------------------------------------------------
; Installation: DEVICE[high]=[<drive>:][<path>\]PAUSE.SYS
;-----------------------------------------------------------------------
; Creation: WASM -wx -we -q -3 -bt=DOS -mt PAUSE
;           WDIS -l -fi PAUSE
;           WLINK op q,map format dos com file PAUSE name PAUSE.SYS
; Untested: MASM PAUSE && LINK PAUSE && EXE2BIN PAUSE PAUSE.SYS
;-----------------------------------------------------------------------
;                                               (2010, Frank Ellermann)
;-----------------------------------------------------------------------

.errndef __TINY__               ;DOS device drivers are tiny (DS == CS)
         .386                   ;allow .386 instructions, e.g., "setne"
DGROUP   group  _TEXT
_TEXT    segment use16 para public 'CODE'
         assume nothing
         assume cs:DGROUP

DEVNAME  equ    "$PAUSE$$"
device   dd     -1              ;device link
         dw     8000h           ;attribute 15 character device
         dw     offset strategy ;device strategy  entry offset
         dw     offset intentry ;device interrupt entry offset
         db     DEVNAME         ;character device name

;-----------------------------------------------------------------------
CMD      equ    02              ;offset command
STATUS   equ    03              ;offset status code
BUFFER   equ    14              ;offset I/O buffer / device end address
CONFIG   equ    18              ;offset addr. init. string [BPB pointer]

;-----------------------------------------------------------------------
; Serialization strategy:  Each request is initialized with status busy.
; If the old request offset is -1 (invalid) a new request can be noted.
; The request offset is invalidated (-1) at the begin of intentry.  If
; the request offset is invalid intentry exits.  A "running" semaphore
; is incremented at the start of intentry and decremented at exit.  The
; initial running value is -1 and permits intentry to process a request.

request  dd     -1              ;request block address pointer
running  db     -1
pause    db     7,13,"PAUSE",13,36

strategy proc   far
         pushf
         cli
         mov    word ptr es:[bx+STATUS],200h    ;status busy, not ready
         cmp    word ptr cs:request+0,-1        ;at most one request
         jne    intbusy
         mov    word ptr cs:request+0,bx        ;ES:BX is address...
         mov    word ptr cs:request+2,es        ;...of request block
intbusy: popf
         retf
strategy endp

;-----------------------------------------------------------------------
intentry proc   far
         pushf
         pusha                  ;save registers
         push   ds
         push   es
         cld
         push   cs
         pop    ds              ;data in code segment
         assume ds:DGROUP

         inc    byte ptr running
         jnz    intnop
         les    di,request      ;ES:DI request
         mov    si,-1           ;invalidate request
         cmp    si,di
         je     intnop          ;no pending request
         mov    word ptr request,si

         mov    ax,8003h        ;unknown request
         cmp    byte ptr es:[di+CMD],0
         jne    intbad          ;support only init (0)
         call   init

intbad:  or     ah,1            ;status ready bit
         mov    es:[di+STATUS],ax
intnop:  dec    byte ptr running
         pop    es              ;restore registers
         pop    ds
         popa
         popf
         retf
intentry endp

;-----------------------------------------------------------------------
init     proc   near            ;device initialization
         push   es              ;preserve ES:DI request
         push   di
         inc    si              ;cheap 0 (resident size)
         mov    es:[di+BUFFER+0],si
         mov    es:[di+BUFFER+2],cs

         mov    ah,12h          ;keyboard shift status
         int    16h
         mov    bp,ax
         mov    ah,9
         mov    dx,offset pause
         int    21h

waiting: mov    ah,12h          ;keyboard shift status
         int    16h
         cmp    bp,ax
         jne    exiting
         mov    ah,11h          ;keyboard peek
         int    16h
         jz     waiting

eatkeys: mov    ah,11h          ;keyboard peek
         int    16h
         jz     exiting
         mov    ah,10h          ;eat pressed key(s)
         int    16h
         jmp    eatkeys

exiting: pop    di              ;restore ES:DI request
         pop    es
         xor    ax,ax
         ret                    ;AX = 0 (okay)
init     endp

_TEXT    ends
         end    device
