;-----------------------------------------------------------------------
; Source for MASM SMALLEST, LINK SMALLEST, EXE2BIN SMALLEST SMALLEST.SYS
;-----------------------------------------------------------------------
.        segment para stack     ;dummy makes linker happy
.        ends

code     segment

         assume cs:code,ds:code,es:nothing,ss:nothing

         dd     -1              ;device link
attrib   dw     08C0h           ;device attribute bits 11,7,6
         dw     offset strategy ;device strategy  entry offset
         dw     offset intentry ;device interrupt entry offset
         db     SUBUNITS        ;subunits, followed by 7 nulls
         db     7 dup (0)       ;          (instead of a name)

request  dd     (?)             ;request block address pointer

;-----------------------------------------------------------------------
; device attribute bit 11 "OCR" support open / close / removeable media
; device attribute bit  7 support DOS 4.0 ... generic IOCTL function 25
; device attribute bit  6 support DOS 3.2 ... generic IOCTL function 19
;
; definition of subunits and request offsets:

SUBUNITS equ     1              ;device with 1 subunit

REQSIZE  equ     0              ;offset request block size
SUBUNIT  equ     1              ;offset [device subunit]
FUNCTION equ     2              ;offset device function
STATUS   equ     3              ;offset device status word

DRIVE    equ    13              ;offset medium byte / supported drives
GENF     equ    13              ;offset generic IOCTL major & minor f.
BUFFER   equ    14              ;offset I/O buffer / device end address
COUNT    equ    18              ;offset I/O buffer length bytes[sectors]
CONFIG   equ    18              ;offset addr. init. string [BPB pointer]
GENP     equ    19              ;offset generic IOCTL parameter address
FIRST    equ    20              ;offset start sector number word
VOLID    equ    22              ;offset drive number/volume ID address

;; CREAD equ    13              ;offset next available character
;; SEC32 equ    22              ;offset start sector double word

;-----------------------------------------------------------------------
; SMALLEST possible RAM disk allowing MKDIR, FORMAT, DISKCOPY (if there
; are 2 of it), RMDIR (RMDIR bug assumes at least 128 bytes per cluster,
; otherwise SMALLEST would be 64 bytes smaller), and CHKDSK (DOS 5 only,
; below DOS 5 CHKDSK does not like 64 bytes per sector).

CLUSTER  equ    2               ;cluster of 2 64 bytes sectors for RMDIR

;-----------------------------------------------------------------------
; list of device command offsets:

commands dw     offset init     ; 0: initialization
         dw     offset check    ; 1: medium test
         dw     offset build    ; 2: build BPB
         dw     offset error    ; 3:  input IOCTL  (4402/4404h if bit E)
         dw     offset read     ; 4:  input
         dw     offset busy     ; 5:  input non-destructive no wait
         dw     offset dummy    ; 6:  input status      (4406h)
         dw     offset dummy    ; 7:  input buffer flush
         dw     offset write    ; 8: output
         dw     offset write    ; 9: output with verification
         dw     offset dummy    ;10: output status      (4407h)
         dw     offset dummy    ;11: output buffer flush
         dw     offset error    ;12: output IOCTL  (4403/4405h if bit E)
         dw     offset open     ;13: Open                     (if bit B)
         dw     offset close    ;14: Close                    (if bit B)
         dw     offset dummy    ;15: Removeable media   (4408h if bit B)
         dw     offset dummy    ;16: output until busy
         dw     offset dummy    ;17: unknown / reserved
         dw     offset dummy    ;18: unknown / reserved
         dw     offset generic  ;19: generic IOCTL (440C/440Dh if bit 6)
         dw     offset dummy    ;20: unknown / reserved
         dw     offset dummy    ;21: unknown / reserved
         dw     offset dummy    ;22: unknown / reserved
         dw     offset getset   ;23: get logical device (440Eh if bit 6)
         dw     offset getset   ;24: set logical device (440Fh if bit 6)
         dw     offset gentest  ;25: generic check (4410/4411h bits 6,7)

UNKNOWN  equ    ($ - offset commands) shr 1

;-----------------------------------------------------------------------
strategy proc   far             ;store request block address

         mov    word ptr cs:request,bx          ;ES:BX is address...
         mov    word ptr cs:request+2,es        ;...of request block
         ret

strategy endp

intentry proc   far             ;execute request block

         push   ax              ;save registers
         push   bx
         push   cx
         push   dx
         push   di
         push   si
         push   bp
         push   ds
         push   es
         pushf

         cld
         push   cs
         pop    ds              ;address data in code segment

         les    di,request      ;request ES:DI
         mov    bl,es:[di+SUBUNIT]
         cmp    bl,SUBUNITS
         mov    ax,8001h        ;status unknown subunit
         jnb    exit
         mov    bl,es:[di+FUNCTION]
         cmp    bl,UNKNOWN      ;function number
         mov    ax,8003h        ;status unknown function
         jnb    exit

         shl    bl,1
         xor    bh,bh           ;offset in table of commands
         xor    ax,ax           ;call command with AX = 0 ok
         call   [commands+bx]

         les    di,cs:request   ;restore ES:DI

exit:    or     ah,1            ;status ready bit
         mov    es:[di+STATUS],ax

         popf                   ;restore registers
         pop    es
         pop    ds
         pop    bp
         pop    si
         pop    di
         pop    dx
         pop    cx
         pop    bx
         pop    ax
         ret

intentry endp

;-----------------------------------------------------------------------
dummy    proc   near
;; done: xor    ax,ax           ;you want nothing and
         ret                    ;you will receive it
dummy    endp

error    proc   near
         mov    ax,8003h        ;status unsupported function
         ret
error    endp

busy     proc   near            ;status busy for no wait
         or     ah,2            ;non destructive input 5
         ret
busy     endp

check    proc   near            ;test medium change
         mov    byte ptr es:[di+BUFFER],1
         ret                    ;ready, no change (1)
check    endp

open     proc   near            ;increment opened counter:
         inc    opened          ;counted but not evaluated
         ret
open     endp

close    proc   near            ;decrement opened counter:
         dec    opened          ;counted but not evaluated
         ret
close    endp

getset   proc   near            ;logical drive always zero
         mov    es:[di+DRIVE],al
         ret
getset   endp

;-----------------------------------------------------------------------
build    proc   near            ;build BPB, here return its address

         mov    word ptr es:[di+CONFIG],offset bpb
         mov    es:[di+CONFIG+2],ds

         les    di,es:[di+BUFFER]
         mov    cx,64
         mov    si,cx           ;DS:SI = ramdisk + sector size = FAT
         lea    si,[ramdisk+si]
         rep    movsb           ;copy to buffer ES:DI 1st sector FAT
         ret

build    endp

;-----------------------------------------------------------------------
diskio   proc   near

write    label  near

         xor    bp,bp           ;0 move DOS data to disk
         jmp    short move

read     label  near

         mov    bp,1            ;1 move disk data to DOS

move:    mov    ax,es:[di+FIRST]
         mov    cl,2            ;number 1st sector
         shl    ax,cl           ;convert to paragraphs
         add    ax,rambeg       ;paragraphs from begin
         mov    bx,ax           ;sector address BX:0

         mov    ax,es:[di+COUNT]
         shl    ax,cl           ;number of sectors
         jz     nomove          ;convert to paragraphs

         mov    dx,ax           ;max. 1000h paragraphs
         dec    dx              ;tested as max. 0FFFh
         test   dh,11110000b
         jnz    fail            ;more than 64 KB ?
         add    dx,bx
         cmp    dx,ramend
         jnb    fail            ;inside RAM disk ?

         mov    cl,3            ;convert to words
         shl    ax,cl
         mov    cx,ax           ;number of words

         les    di,es:[di+BUFFER]
         mov    ds,bx           ;buffer address ES:DI
         xor    si,si           ;sector address DS:SI
         or     bp,bp           ;0 write, 1 read
         jnz    moveit

         push   es
         pop    ds
         mov    es,bx           ;swap es, ds
         xchg   si,di           ;swap si, di

moveit:  rep    movsw
         xor    ax,ax           ;ready
         ret

fail:    xor    ax,ax           ;number of sectors
         mov    es:[di+COUNT],ax
         mov    ax,8008h        ;sector not found
nomove:  ret

diskio   endp

;-----------------------------------------------------------------------
; for simplicity here default BPB = medium BPB as found on RAM disk bpb:

;; dBPB  dw     (?)             ;sector size in bytes     ;00   0  bpb
;;       db     (?)             ;1 sector per cluster     ;02   2   :
;;       dw     (?)             ;1 reserved = this sector ;03   3   :
;;       db     (?)             ;1 FAT                    ;05   5   :
;;       dw     (?)             ;root directory entries   ;06   6   :
;;       dw     (?)             ;sector number  <= 32 MB  ;08   8   :
;;       db     (?)             ;medium id                ;0A  10   :
;;       dw     (?)             ;FAT sectors              ;0B  11   :
;;       dw     (?)             ;sectors per track dummy  ;0D  13   :
;;       dw     (?)             ;number of heads          ;0F  15   :
;;       dd     (?)             ;hidden sectors           ;11  17   :
;;       dd     (?)             ;sector number   > 32 MB  ;15  21   :
opened   dw     0               ;open count (here unused) ;19  25   ??
density  db     0               ;0/1 normal/double density;1B  27   ??
devtype  db     6               ;0 360K, 1 ... 4, 5 disk, ;1C  28   ?
                                ;6 tape, 7 1.44M, 8 2.88 ?
devattr  db     2,0             ;change line support etc. ;1D  29   ?
trknum   dw     (?)             ;tracks (here = sectors)  ;1F  31   ?
;; mBPB  db     25 dup (?)      ;medium  BPB              ;21  33   ?

gentrk   dw     1               ;"track" layout sector ...
         dw     1               ;... with number 1 and ...
         dw     64              ;... sector size in bytes

rambeg   dw     (?)             ;rambeg is start segment of RAM disk
ramend   dw     (?)             ;ramend is  end  segment behind disk
rambpb   dw     offset bpb,(?)  ;address 1st and only RAM disk BPB

;-----------------------------------------------------------------------
genlist  db     40h             ;generic IOCTL minor function table
         dw     offset parmset
         db     60h
         dw     offset parmget
         db     41h
         dw     offset trackio
         db     61h
         dw     offset trackio
         db     42h
         dw     offset forver
         db     62h
         dw     offset forver
         db     46h
         dw     offset volser
         db     66h
         dw     offset volser
         db     47h
         dw     offset setlock  ;here not supported
         db     67h
         dw     offset getlock  ;i.e. only reported
;;       db     68h
;;       dw     offset genferr  ;INT 13h AH 20h ???
MAXIOCTL equ    (($ - offset genlist)/3)

genlook  proc   near            ;generic IOCTL function list search

         mov    ax,es:[di+GENF] ;AL major, AH minor function number
         cmp    al,8
         jnz    retzero         ;block device supports only major 8

         mov    cx,MAXIOCTL     ;search minor function AH in list
         mov    si,offset genlist-3

search:  lea    si,[si+3]       ;code byte + function offset word,
         cmp    ah,[si]         ;function offset follows code byte
         loopne search

retzero: ret                    ;return (N)Z function (not) found

genlook  endp

;-----------------------------------------------------------------------
gentest  proc   near            ;generic IOCTL 840..847, 860..868

         call   genlook         ;check generic IOCTL function
         jnz    genferr         ;not zero if unknown function

         xor    ax,ax           ;status okay = supported
         ret

genferr: mov    ax,8003h        ;status unknown function
         ret

gentest  endp

generic  proc   near            ;generic IOCTL 840..847, 860..868

         call   genlook         ;check generic IOCTL function
         jnz    genferr         ;not zero if unknown function

         les    di,es:[di+GENP] ;ES:DI generic IOCTL parameters
         jmp    [si+1]          ;function offset follows code byte

generic  endp

;-----------------------------------------------------------------------
parmset  proc   near            ;generic IOCTL 840h set parameters

         mov    bl,es:[di]      ;+0 special function byte
         inc    di
         mov    ax,800Fh        ;prepare error code: no change allowed !
         mov    si,offset devtype
         cmpsb                  ;test device type + attributes + tracks:
         jnz    parmerr
         cmpsw                  ;skip attributes
         cmpsw                  ;test track number
         jnz    parmerr
         scasb                  ;skip density
         mov    si,offset bpb
         mov    cl,25           ;test 25 bytes BPB
         repe   cmpsb
         jnz    parmerr
         test   bl,00000100b    ;if special bit 2: no new "track" layout
         jnz    retokay
         mov    si,offset gentrk
         mov    cl,3            ;test  6 bytes "track" layout
         repe   cmpsw
         jnz    parmerr
retokay: xor    ax,ax           ;status okay or
parmerr: ret                    ;status 800Fh

parmset  endp

;-----------------------------------------------------------------------
parmget  proc   near            ;generic IOCTL 860h get parameters

         inc    di              ;0 special function byte here irrelevant
         mov    si,offset devtype
         movsb                  ;copy device type + attributes + tracks:
         lodsw
         and    ax,3            ;bit 0 is not, bit 1 supports changeable
         stosw                  ;copy attributes (only change line bits)
         movsw                  ;copy track number
         mov    al,density
         stosb                  ;copy density
         mov    si,offset bpb
         mov    cl,25           ;copy 25 bytes BPB
         rep    movsb
         xor    ax,ax           ;get must not handle "track" layout !
         ret

parmget  endp

;-----------------------------------------------------------------------
forver   proc   near            ;generic IOCTL minor AH 42 / 62

         call   tracktst        ;check head and track
         jc     badseek         ;carry: AX code 8006h

         xor    ax,ax           ;format / verify okay
badseek: ret

forver   endp

tracktst proc   near            ;track test used by trackio / forver

         cmp    word ptr es:[di+1],0
         jnz    seekerr         ;+1 head number = 0 ?
         mov    bx,es:[di+3]    ;+3 "track" sector BX
         cmp    bx,trknum
         jnb    seekerr         ;BX inside RAM disk ?
         clc
         ret

seekerr: mov    ax,8006h        ;"seek" error, e.g. head not 0
         stc
         ret

tracktst endp

;-----------------------------------------------------------------------
trackio  proc   near            ;generic IOCTL minor AH 41 / 61

         call   tracktst        ;check head and track
         jc     diskerr         ;carry: AX code 8006h

         cmp    word ptr es:[di+5],0
         jnz    secterr         ;+5 first & only "track" sector ?
         cmp    word ptr es:[di+7],1
         jnz    secterr         ;+7 = one & only "track" sector ?

         mov    cl,2            ;convert to paragraphs
         shl    bx,cl
         add    bx,rambeg       ;paragraphs from begin
         les    di,es:[di+9]    ;buffer address ES:DI
         mov    ds,bx           ;sector address DS:SI
         xor    si,si           ;CX = number of words
         mov    cx,32
         cmp    ah,41h          ;41 write, 61 read
         jnz    trkmov

         push   es
         pop    ds
         mov    es,bx           ;swap ES, DS
         xchg   si,di           ;swap SI, DI

trkmov:  rep    movsw
         xor    ax,ax
         ret

secterr: mov    ax,8008h        ;sector not found
diskerr: ret

trackio  endp

;-----------------------------------------------------------------------
volser   proc   near            ;generic IOCTL minor AH 46 / 66

         mov    si,offset ramdisk+26h
         lodsb                  ;DS:SI boot sector volume id.
         cmp    al,41           ;DOS 4 & above disk format ?
         jnz    novol

         scasw                  ;ES:DI generic IOCTL offset 2
         mov    cx,23           ;4 vol. ser., 11 name, 8 type
         cmp    ah,46h          ;46 write, 66 read
         jnz    volmov

         push   es
         pop    ds
         push   cs
         pop    es              ;swap ES, DS
         xchg   si,di           ;swap SI, DI

volmov:  rep    movsb
         xor    ax,ax
         ret

novol:   mov    ax,8007h        ;illegal medium: vol. id. not found
         ret

volser   endp

;-----------------------------------------------------------------------
setlock  proc   near            ;generic IOCTL 847h set access lock (?)

         mov    ah,es:[di+1]    ;dubious, imitate DOS driver
         mov    al,devattr+1
         or     al,00000010b    ;set bit 1
         or     ah,ah
         jnz    newlock
         and    al,11111101b    ;clear bit
newlock: mov    devattr+1,al
         xor    ax,ax
         ret

setlock  endp

getlock  proc   near            ;generic IOCTL 867h get access lock (?)

         mov    al,devattr+1    ;dubious, imitate DOS driver
         and    al,00000010b    ;get bit 1
         shr    al,1
         mov    es:[di+1],al    ;0 / 1 set
         xor    ax,ax
         ret

getlock  endp

;-----------------------------------------------------------------------
         align  16              ;align at paragraph boundary

ramdisk  proc   far                                       ;offset

         int    18h             ;boot sector              ;00   0
         ret                    ;dummy boot routine       ;02   2
         db     "ellerman"      ;manufacturer             ;03   3
bpb      dw     64              ;sector size in bytes     ;0B  11  BPB
         db     CLUSTER         ;2 sectors per cluster    ;0D  13   :
         dw     1               ;1 reserved = this sector ;0E  14   :
         db     1               ;1 FAT                    ;10  16   :
         dw     2               ;root directory entries   ;11  17   :
secnum   dw     3+CLUSTER       ;sector number  <= 32 MB  ;13  19   :
         db     0F8h            ;medium id                ;15  21   :
         dw     1               ;FAT sectors              ;16  22   :
         dw     1               ;sectors per track dummy  ;18  24   :
         dw     1               ;number of heads          ;1A  26   :
         dd     0               ;hidden sectors           ;1C  28   :
         dd     0               ;sector number   > 32 MB  ;20  32   :
         dw     0               ;unknown or reserved      ;24  36   ?
         db     41              ;41 DOS 4 & above format: ;26  38
         dd     12345678h       ;evtl. 4 bytes vol. ser.  ;27  39
volabel  db     "Minidisk ? "   ;evtl.11 bytes vol. name  ;2B  43
         db     "FAT 12  "      ;evtl. 8 bytes vol. type  ;36  54
         db     55h,0AAh        ;to make NORTON DE happy  ;3E  62

         db     0F8h,0FFh,0FFh  ;12 bits FAT
         db     0FFh,08Fh,000h  ;12 bits FAT
         db     58 dup (0)      ;rest of FAT

dilabel  db     "Minidisk ? ",8
         db     10 dup (0)
         dw     (13 shl 11)+(23 shl 5)+31       ;time 13:23:62
         dw     ((91-80) shl 9)+(9 shl 5)+18    ;date 91-09-18
         db     6 dup (0)       ;32 bytes per directory entry

         db     "READ    ME ",0
         db     10 dup (0)
         dw     (13 shl 11)+(23 shl 5)+31       ;time 13:23:62
         dw     ((91-80) shl 9)+(9 shl 5)+18    ;date 91-09-18
         dw     2               ;1st cluster
         dd     FILESIZE        ;size

        if      (CLUSTER / 2)
topofile db     "Smallest possible disk allowing "
         db     "FORMAT, DISKCOPY (if 2 disks), M"
         db     "D, RD and",13,10,"CHKDSK (DOS 5 only) -"
         db     " (c) '91 by Frank Ellermann",13,10,26
        else
topofile db     "Disk allowing FORMAT, DISKCOPY, "
         db     "MD, DOS 5 CHKDSK, but not RMDIR",26
        endif
FILESIZE equ    ($ - offset topofile)

ramdisk  endp

;-----------------------------------------------------------------------
init     proc   near            ;device initialization (overlay part)

         mov    al,es:[di+VOLID]        ;above DOS 3.0
         add    al,"A"          ;drive 3 C:, 4 D:, ...
         mov    byte ptr volabel+9,al
         mov    byte ptr dilabel+9,al
         mov    byte ptr message+9,al

         mov    byte ptr es:[di+DRIVE],SUBUNITS         ;device units
         mov    word ptr es:[di+CONFIG],offset rambpb
         mov    es:[di+CONFIG+2],ds                     ;BPB pointer
         mov    rambpb+2,ds                             ;own segment

         mov    dx,offset ramdisk
         mov    cl,4            ;convert ramdisk offset to paragraphs
         shr    dx,cl
         mov    ax,ds           ;add paragraphs to own segment, note
         add    ax,dx           ;result (i.e. ramdisk start segment)
         mov    rambeg,ax

         mov    dx,secnum
         mov    trknum,dx       ;stored as disk length
         mov    cl,2            ;2 **  4 = 16 = paragraph length
         shl    dx,cl           ;convert disk size to paragraphs
         add    ax,dx
         mov    ramend,ax               ;end address = ramdisk segment
         mov    es:[di+BUFFER+2],ax     ; + paragraphs number offset 0
         mov    word ptr es:[di+BUFFER],0

         mov    dx,offset message
         mov    ah,9                    ;display init message
         int    21h
         xor    ax,ax
         ret

init     endp

message  db     "Minidisk ? installed - (c) '91 by F. Ellermann",13,10,"$"

code     ends
         end
