;-----------------------------------------------------------------------
; TRY.ASM source for TRY.EXE program: MASM TRY, LINK TRY
;-----------------------------------------------------------------------

         assume cs:code, ds:data, es:data, ss:stack

data     segment para public 'DATA'

pathptr  dd     (?)             ;address actual PATH
switch   dw     '/\'            ;DOS path characters

execpar  dw     (?)             ;segment environment
         dd     (?)             ;pointer command line
fcb1     dd     5Ch             ;pointer own 1st FCB
fcb2     dd     6Ch             ;pointer own 2nd FCB

args     dd     80h             ;pointer own arguments

exe      db     '.\????????.EXE    EXE'         ;4 blanks for parse FCB
com      db     '.\????????.COM    COM'         ;EXE, COM for test type

comline  db     128 dup (0)     ;DTA copy used for DOS external command
command  db     128 dup (0)     ;buffer to construct PATH token command

pathtxt  db     'PATH=',0       ;search PATH setting

;-----------------------------------------------------------------------
;        usage and other messages

usage    db     13,10,'TRY.EXE, copyright (C) 1991 by Frank Ellermann',13
  db 10,10,'usage: TRY [<path>]<name>[.<extension>] [<arguments>]',13
  db 10,10,'or in other words enter "TRY " followed by your command'
  db 13,10,'<name> with <path> or <arguments> (or even redirection)'
  db 13,10,'as usual. TRY will execute your command and display any'
  db 13,10,'non-zero return code.'
  db 13,10,'You cannot TRY batch files (*.BAT) or internal commands'
  db 13,10,'like DIR. TRY executes <name> directly without subshell'
  db 13,10,'(COMMAND.COM or INT 2Eh would allow batch files and DOS'
  db 13,10,'internal commands, but "eat" return codes).'
  db 13,10,'TRY looks for your command (if no path specified) first'
  db 13,10,'in actual directory (of specified disk) and then in all'
  db 13,10,'directories of your PATH until <name>.COM or <name>.EXE'
  db 13,10,'found.  Unlike DOS TRY respects an explicitly specified'
  db 13,10,'command extension, you are asked to press "y" or "Y" if'
  db 13,10,'it is neither COM nor EXE (dangerous !).'
  db 13,10,'TRY writes its own messages to STDERR (usually display)'
  db 13,10,'and takes keys directly from the keyboard. Redirections'
  db 13,10,'of STDIN or STDOUT do not interfere with TRY.',13
  db 10,10,'Your PATH is ',0

missing  db     13,10,7,'TRY cannot locate "',0
missend  db     '"',0
misscom  db     '" or "',0

typetry  db     13,10,7,'TRY neither COM nor EXE "',0
typeask  db     '" (extremely dangerous, Yes or No) ? ',0

echoyes  db     'Yes',13,10,0
echono   db     'No',13,10,0
crlf     db     13,10,0

errname  db     13,10,7
  db       'TRY cannot parse illegal drive or ambiguous command',13,10,0
memory   db     13,10,7
  db       'TRY cannot start, DOS reports memory management error',13,10,0

;-----------------------------------------------------------------------
;        error meaning tables

exectext db     13,10,7,'DOS call error code '  ;patched by x2c
execcode db     'xxxxh - command not run ',0
exittext db     13,10,7,'program return code '  ;patched by x2c
exitcode db     'xxxxh ',0
altext   db     13,10,'DOS exit code meaning '  ;patched by x2c
alcode   db     'xxh : ',0

high0    db     '(00..h normal termination)',0
high1    db     '(01..h ^C or ^BREAK abort)',0
high2    db     '(02..h critical error abort)',0
high3    db     '(03..h staying resident)',0
highx    db     '(??..h unknown termination code ?)',0

hightab  dw     offset high0, offset high1, offset high2, offset high3
         dw     offset highx                    ;table end default
HIGHMAX  equ    (($-offset hightab) shr 1)-1    ;exclusive default

err01    db     'Invalid function number',0     ;1..31 DOS 2.x errors
err02    db     'File not found',0
err03    db     'Path not found',0
err04    db     'Too many open files',0
err05    db     'Access denied',0
err06    db     'Invalid handle',0
err07    db     'Memory control blocks destroyed',0
err08    db     'Insufficient memory',0
err09    db     'Invalid memory block address',0
err10    db     'Invalid environment',0
err11    db     'Invalid format',0
err12    db     'Invalid access code',0
err13    db     'Invalid data',0

err15    db     'Invalid disk drive',0
err16    db     'Attempt to remove current directory',0
err17    db     'Not same device',0
err18    db     'No more files',0

err19    db     'Disk write-protected',0        ;critical error 1..12
err20    db     'Unknown disk unit',0
err21    db     'drive not ready',0
err22    db     'Unknown command',0
err23    db     'Data error (CRC)',0
err24    db     'Bad request structure length',0
err25    db     'Seek error',0
err26    db     'Unknown media type',0
err27    db     'Sector not found',0
err28    db     'Printer out of paper',0
err29    db     'Write fault',0
err30    db     'Read fault',0
err31    db     'General failure',0

err32    db     'Sharing violation',0           ;32 etc. DOS 3 errors
err33    db     'Lock violation',0
err34    db     'Invalid disk change',0
err35    db     'FCB unavailable',0
;;;36    db     'Sharing buffer overflow',0

err36    db     'System resources exhausted',0  ;36...39 DOS 4 errors
err37    db     'Code page mismatch',0
err38    db     'Out of input',0
err39    db     'Insufficient disk space',0

err50    db     'Network request not supported',0
err51    db     'Remote computer not listening',0
err52    db     'Duplicate name on network',0
err53    db     'Network name not found',0
err54    db     'Network busy',0
err55    db     'Network device no longer exists',0
err56    db     'Network BIOS command limit exceeded',0
err57    db     'Network adapter hardware error',0
err58    db     'Incorrect response from network',0
err59    db     'Unexpected network error',0
err60    db     'Incompatible remote adapter',0
err61    db     'Print queue full',0
err62    db     'Print queue not full',0
err63    db     'Print file deleted (not enough space)',0
err64    db     'Network name deleted',0
err65    db     'Access denied',0
err66    db     'Network device type incorrect',0
err67    db     'Network name not found',0
err68    db     'Network name limit exceeded',0
err69    db     'Network BIOS session limit exceeded',0
err70    db     'Temporarily paused',0
err71    db     'Network request not accepted',0
err72    db     'Print or disk redirection paused',0

err80    db     'File already exists',0

err82    db     'Cannot make directory entry',0
err83    db     'Failure on Int 24H',0
err84    db     'Too many redirections',0
err85    db     'Duplicate redirection',0
err86    db     'Invalid password',0
err87    db     'Invalid parameter',0
err88    db     'Network data fault',0          ;network device fault ?

errnn    db     'Unknown DOS error code',0

errtab   dw     offset errnn                    ;offset message 0, ...
         dw     offset err01, offset err02, offset err03, offset err04
         dw     offset err05, offset err06, offset err07, offset err08
         dw     offset err09, offset err10, offset err11, offset err12
         dw     offset err13, offset errnn, offset err15, offset err16
         dw     offset err17, offset err18, offset err19, offset err20
         dw     offset err21, offset err22, offset err23, offset err24
         dw     offset err25, offset err26, offset err27, offset err28
         dw     offset err29, offset err30, offset err31, offset err32
         dw     offset err33, offset err34, offset err35, offset err36
         dw     offset err37, offset err38, offset err39
         dw     10 dup (offset errnn)
         dw                   offset err50, offset err51, offset err52
         dw     offset err53, offset err54, offset err55, offset err56
         dw     offset err57, offset err58, offset err59, offset err60
         dw     offset err61, offset err62, offset err63, offset err64
         dw     offset err65, offset err66, offset err67, offset err68
         dw     offset err69, offset err70, offset err71, offset err72
         dw     07 dup (offset errnn),                    offset err80
         dw     offset errnn, offset err82, offset err83, offset err84
         dw     offset err85, offset err86, offset err87, offset err88
         dw     offset errnn                    ;table end default
ERRMAX   equ    (($-offset errtab) shr 1)-1     ;exclusive default

data     ends

;-----------------------------------------------------------------------
code     segment para public 'CODE'

main     proc   far             ;program entry point

         mov    ax,data         ;install data segment DS
         mov    ds,ax

         mov    bx,ss           ;SS:SP at end of program
         mov    ax,es           ;ES:0000h at program PSP
         sub    bx,ax           ;paragraph size segments
         mov    cl,4
         mov    ax,sp           ;offset to stack pointer
         shr    ax,cl           ;converted to paragraphs
         add    bx,ax           ;paragraph size w/ stack

         mov    ah,4ah          ;modify allocated memory to
         int    21h             ;needed size i.e. free rest
         jnc    envir           ;carry flag memory error

         mov    dx,offset memory
         call   message
         jmp    execerr

;-----------------------------------------------------------------------
;        handle arguments and prepare exec parameters

noarg:   mov    dx,offset usage ;no command argument
         call   message
         lds    dx,pathptr      ;display PATH if any
         xor    ax,ax
         jmp    exitmsg         ;exit with AL 0 okay

envir:   mov    bx,2Ch          ;PSP offset 2Ch environment
         mov    bx,es:[bx]
         mov    execpar,bx      ;own environmemt segment BX
         mov    word ptr fcb1+2,es
         mov    word ptr fcb2+2,es
         mov    word ptr args+2,es

         push   ds
         pop    es              ;target ES data segment
         lds    si,args         ;source DS:SI arguments
         mov    di,offset comline
         mov    cx,64           ;copy arguments line for
         rep    movsw           ;use as external command

         push   es
         pop    ds
         call   initpath        ;search PATH for pathptr

         mov    si,offset comline
         mov    di,si           ;command name buffer
         lodsb
         cbw                    ;byte 1: size to word
         mov    cx,ax           ;size argument string

testarg: jcxz   noarg           ;any character left ?
         dec    cx
         lodsb
         cmp    al,' '          ;skip controls & ' '
         jbe    testarg         ;blank, tab, lf, etc.

         dec    si              ;1st char. above ' '
         inc    cx              ;rest size inclusive
         mov    al,byte ptr switch+1
         mov    ah,'?'          ;switch + '?' ('/?')
         cmp    [si],ax
         je     noarg           ;caller needs help !

cominc:  cmp    byte ptr [si],' '
         jbe    comgot          ;copy 1st argument to
         movsb                  ;command name buffer
         loop   cominc
comgot:  xor    ax,ax
         stosb                  ;AL 0 to name buffer

         lea    bx,[si-1]       ;rest length of arguments
         mov    [bx],cl         ;to new command line size
         mov    word ptr execpar+02,bx
         mov    word ptr execpar+04,ds

         les    di,fcb1         ;PSP offset 5Ch is 1st FCB
         mov    ax,2901h        ;parse 2nd argument to FCB
         int    21h             ;(skip leading separators)

         les    di,fcb2         ;PSP offset 6Ch is 2nd FCB
         mov    ax,2901h        ;parse 3rd argument to FCB
         int    21h             ;(incompatible simplified)

;-----------------------------------------------------------------------
;        parse command to file name, ask if type not COM or EXE

         push   ds
         pop    es
         mov    dx,offset comline
         call   strlen          ;lenght of command name
         mov    di,dx           ;scan end of path in DI
         mov    al,byte ptr switch

haspath: mov    si,di           ;keep end of path in SI
         jcxz   endpath         ;skip specified path
         repne  scasb           ;scan path character AL
         jz     haspath

endpath: xchg   dx,si           ;keep end of path in DX
         mov    cx,dx           ;determine length in CX
         sub    cx,si           ;(use path length excl.
         push   cx              ; command name if given)

         mov    si,dx
         mov    di,offset com   ;parse '????????.COM',0
         call   parse           ;or explicit extension

         mov    si,dx
         mov    di,offset exe   ;parse '????????.EXE',0
         call   parse           ;or explicit extension

         pop    cx              ;restore path length CX
         or     al,al
         jnz    badname         ;bad drive or '*' / '?'

         mov    di,offset com+2
         call   comorexe        ;file extension 'COM' ?
         je     search
         mov    di,offset exe+2
         call   comorexe        ;file extension 'EXE' ?
         je     search

         push   cx              ;keep path length CX
         mov    dx,offset typetry
         call   message
         mov    dx,offset exe+2
         call   message         ;neither COM nor EXE
         mov    dx,offset typeask
         call   message         ;ask for TRY command
         call   yesorno
         pop    cx              ;kept path length CX
         jz     search

         mov    al,5            ;rc 5 access denied
         jmp    exitnul

badname: mov    dx,offset errname
         jmp    exitmsg         ;parse returned error !

;-----------------------------------------------------------------------
;        search command (given type or COM / EXE, given path or PATH)

search:  mov    bx,offset command
         jcxz   nopath          ;no path specified ?

         mov    si,offset comline
         mov    di,bx           ;command file target
         rep    movsb           ;copy specified path

         mov    dx,offset com+2
         push   di              ;keeping target DI
         call   strcpy          ;try xxx.COM at DI
         pop    di              ;restore target DI
         mov    dx,bx           ;command file path
         mov    ax,4300h        ;test COM existence:
         int    21h             ;get file attribute
         jnc    gotfile

         mov    dx,offset exe+2
         call   strcpy          ;try xxx.EXE at DI
         mov    dx,bx           ;command file path
         mov    ax,4300h        ;test EXE existence:
         int    21h             ;get file attribute
         jnc    gotfile

         mov    dx,offset missing
         push   bx
         call   message         ;cannot find command
         pop    dx              ;with specified path
         call   message
         mov    dx,offset missend
         call   message         ;tell DOS error code
         jmp    execerr

nopath:  mov    dx,offset com   ;test COM existence:
         mov    ax,4300h        ;get file attribute
         int    21h
         jnc    gotfile

         mov    dx,offset exe   ;test EXE existence:
         mov    ax,4300h        ;get file attribute
         int    21h

gotfile: jnc    doit

         call   nextpath        ;DI: next PATH token
         jc     nofile          ;command file target

         mov    dx,offset com+2
         push   di              ;keeping target DI
         call   strcpy          ;try xxx.COM at DI
         pop    di              ;restore target DI
         mov    dx,bx           ;command file path
         mov    ax,4300h        ;test COM existence:
         int    21h             ;get file attribute
         jnc    gotfile

         mov    dx,offset exe+2
         call   strcpy          ;try xxx.EXE at DI
         mov    dx,bx           ;command file path
         mov    ax,4300h        ;test EXE existence:
         int    21h             ;get file attribute

         jmp    gotfile         ;try next PATH token

nofile:  mov    dx,offset missing
         call   message         ;cannot find command
         mov    dx,offset com+2
         call   message         ;COM
         mov    dx,offset misscom
         call   message         ;or
         mov    dx,offset exe+2
         call   message         ;EXE
         mov    dx,offset missend
         call   message

         jmp    short newline

;-----------------------------------------------------------------------
;        execute DOS external command, common exit handling

savesp   dw     (?)             ;DOS 2.x exec can destroy SP
savess   dw     (?)             ;DOS 2.x exec can destroy SS

doit:    push   ds
         push   es
         mov    cs:savess,ss
         mov    cs:savesp,sp    ;DS:DX ASCIIZ command
         mov    ax,4B00h        ;ES:BX exec parameter
         mov    bx,offset execpar
         int    21h             ;DOS exec function in
         cli                    ;DOS 2.x destroys all

         mov    ss,cs:savess    ;no interrupts during
         mov    sp,cs:savesp    ;restauration DS = ES
         pop    es              ;and stack SS:SP
         pop    ds
         sti                    ;interrupts now okay

         jnc    didexec         ;no carry: exec done

execerr: mov    di,offset execcode
         call   x2c             ;convert hex. to ASCII
         mov    dx,offset exectext
         jmp    short badexec

didexec: mov    ah,4Dh          ;get exit code from child
         int    21h
         or     ax,ax
         jz     exitnul

         mov    di,offset exitcode
         call   x2c             ;convert hex. to ASCII
         mov    dx,offset exittext

badexec: lea    si,[di-2]       ;converted AL to alcode
         mov    di,offset alcode
         movsw
         call   message         ;AH termination meaning:
         mov    bx,HIGHMAX      ;default last known + 1
         cmp    ah,bl
         ja     highmsg         ;default last if unknown
         mov    bl,ah
highmsg: shl    bx,1            ;number to table offset
         mov    dx,[bx+offset hightab]

         call   message         ;AL return code meaning:
         or     al,al
         jz     newline

         mov    dx,offset altext
         call   message         ;DOS error code meaning
         mov    bx,ERRMAX       ;default last known + 1
         cmp    al,bl
         ja     lowmsg          ;default last if unknown
         mov    bl,al
lowmsg:  shl    bx,1            ;number to table offset
         mov    dx,[bx+offset errtab]
         call   message

newline: mov    dx,offset crlf  ;append CR & LF to line

exitmsg: call   message         ;ASCIIZ DS:DX to STDERR, keep AL
exitnul: mov    ah,4Ch          ;terminating with return code AL
         int    21h

main     endp

;-----------------------------------------------------------------------
initpath proc   near            ;search for path in environment BX

         push   dx              ;modifies AX, CX, DI, SI
         mov    ax,3700h        ;keeping  BX, DX, DS
         int    21h
         mov    ax,switch       ;get switch character:
         jc     getenv          ;if switch character '/'
         cmp    dl,ah           ;then path character '\'
         jz     getenv          ;else path character '/'
         mov    al,ah
         mov    ah,dl
         mov    switch,ax       ;path & switch character

getenv:  pop    dx
         push   ds
         mov    word ptr pathptr+2,bx
         mov    ds,bx           ;environment segment
         xor    ax,ax           ;DS:SI start BX:0000
         mov    si,ax

scanit:  mov    cx,5
         mov    di,offset pathtxt
         repe   cmpsb           ;look for 'PATH='
         mov    cx,si           ;terminate search at segment limit
         not    cx              ;this will work for length < 64 KB
         jne    skipit          ;CMPSB NOT changed 'PATH=' found ?

         pop    ds              ;restore own data segment
         mov    word ptr pathptr+0,si
         ret                    ;BX:SI is real PATH begin

skipit:  lodsb                  ;look for terminating NUL byte
         or     al,al
         loopnz skipit
         jcxz   envend          ;environment segment > 64 KB ?

         cmp    [si],al         ;go on with search
         jne    scanit          ;unless double NUL

envend:  pop    ds              ;restore own data segment
         lea    si,[pathtxt+5]
         mov    word ptr pathptr+0,si
         mov    word ptr pathptr+2,ds
         ret                    ;DS:SI for NUL PATH dummy

initpath endp

;-----------------------------------------------------------------------
nextpath proc   near            ;search for path in environment

         push   ds              ;modifies AX, DI, SI
         mov    ah,11111111b    ;yet no character mark
         mov    di,offset command
         lds    si,pathptr
         test   ah,[si]
         jnz    incpath         ;handle ASCIIZ string end

         pop    ds              ;restore own data segment
         stc                    ;indicate PATH end (carry)
         ret

incpath: lodsb
         cmp    al,';'
         je     textend         ;handle PATH token end ';'
         or     al,al
         jz     textend         ;handle ASCIIZ string end
         stosb
         mov    ah,al           ;mark for got a character
         jmp    incpath

textend: pop    ds              ;restore own data segment
         mov    word ptr pathptr+0,si
         cmp    ah,11111111b
         jz     nextpath        ;oops, empty path token ?

         cmp    byte ptr [di-1],':'
         jz     pathend         ;expect DOS disk character
         mov    al,byte ptr switch
         cmp    [di-1],al       ;':' or DOS path character
         jz     pathend         ;otherwise patch '\' ('/')
         stosb

pathend: clc                    ;indicate token (no carry)
         ret                    ;DI points to end of token

nextpath endp

;-----------------------------------------------------------------------
parse    proc   near            ;parse name SI to filename.ext DI

         push   di              ;modifies AX, CX, DI, SI
         inc    di              ;skip '.' in target data
         mov    al,byte ptr switch
         stosb                  ;reserve e.g. '.\' or 'A:'

         mov    ax,2908h        ;parse command name SI
         int    21h             ;to DI, keep extension
         or     al,al
         jz     parseok         ;'*' or '?' or bad drive ?

         pop    di              ;restore initial target
         ret                    ;AL > 0 indicates error

parseok: push   di              ;keep target
         mov    cx,8            ;copy filename to begin
         lea    si,[di+1]       ;i.e. overwrite drive X
         rep    movsb
         mov    al,' '          ;AL is terminator blank
         stosb

         pop    di              ;scan for blank end and
         mov    cx,9            ;replace by point
         repne  scasb
         mov    byte ptr [di-1],'.'

         push   di              ;keep target
         mov    cx,3            ;copy file extension SI
         rep    movsb

         pop    di              ;scan for blank end and
         mov    cx,4            ;replace by NUL
         repne  scasb
         xor    ax,ax
         mov    [di-1],al

         pop    di              ;restore initial target
         mov    si,offset comline
         cmp    byte ptr [si+1],':'
         jnz    parsend         ;replace dummy path
         movsw                  ;by specified drive

parsend: ret                    ;indicate okay AL 0

parse    endp

;-----------------------------------------------------------------------
comorexe proc   near            ;file type DI+16 in identifier DI ?

         push   cx              ;modifies AL, DI, SI
         mov    al,'.'          ;keep CX, AH
         lea    si,[di+16]
         mov    cx,9            ;scan type following guaranteed '.'
         repne  scasb
         mov    cx,3            ;test type (uppercase parse result)
         repe   cmpsb           ;for simplicity assume 3 bytes type
         pop    cx
         ret                    ;flag E equal types or NE not equal

comorexe endp

;-----------------------------------------------------------------------
strlen   proc   near            ;return length ASCIIZ string ES:DX

         xchg   di,dx           ;modifies AX, CX
         mov    cx,di           ;keep DX, DI, ES
         not    cx              ;terminate search at segment limit
         push   di              ;this will work for length < 64 KB
         xor    al,al
         repne  scasb           ;search NUL
         mov    cx,di           ;DI points behind NUL (or is NULL)
         pop    di              ;restore DI
         sub    cx,di           ;length inclusive NUL
         dec    cx              ;length exclusive NUL
         xchg   dx,di           ;restore DX
         ret                    ;returns CX string length

strlen   endp

;-----------------------------------------------------------------------
strcpy   proc   near            ;ASCIIZ string DS:DX to ES:DI

         push   cx              ;modifies AX, DI
         push   es              ;keep CX, DX, ES
         push   ds
         pop    es              ;set ES = DS
         call   strlen          ;string length CX
         pop    es              ;load old ES
         jcxz   nulcpy

         push   di              ;target + length
         add    di,cx           ;in segment ES ?
         jnc    allcpy          ;then copy all
         sub    cx,di           ;else truncate

allcpy:  pop    di              ;target DI
         push   si              ;saving SI
         mov    si,dx           ;source DX
         rep    movsb
         pop    si

nulcpy:  mov    [di],cl         ;target terminator
         pop    cx              ;DI is end of copy
         ret

strcpy   endp

;-----------------------------------------------------------------------
message  proc   near            ;ASCIIZ string DS:DX to STDERR

         push   ax              ;modifies BX, CX
         push   es              ;keep AX, DX, DS, ES
         push   ds
         pop    es              ;set ES = DS
         call   strlen          ;CX = strlen( ES:DX )
         pop    es              ;load old ES

         mov    bx,2            ;ASCIIZ string DS:DX to STDERR
         mov    ah,40h
         int    21h
         pop    ax
         ret

message  endp

;-----------------------------------------------------------------------
yesorno  proc   near            ;get key 'y'/'Y'/? and echo 'Yes' / 'No'

         xor    ax,ax           ;modifies AX, BX, CX, DX
         int    16h             ;bypass STDIN redirection
         mov    bx,offset echoyes
         cmp    al,'y'
         je     answer
         cmp    al,'Y'
         je     answer
         xchg   ax,dx
         mov    ax,6523h        ;check national yes char.
         int    21h
         jc     notyes          ;below DOS 4.0 no support
         cmp    ax,1
         je     answer          ;0 no, 1 yes, 2 otherwise

notyes:  mov    bx,offset echono
answer:  mov    dx,bx
         lahf                   ;keep result flag yes E or no NE
         call   message         ;echo as message 'Yes' or 'No'
         sahf                   ;kept result flag yes E or no NE
         ret

yesorno  endp

;-----------------------------------------------------------------------
x2c      proc   near            ;convert word AX to ASCII at ES:DI

         push   cx              ;modifies DI
         mov    cx,404h         ;keep AX, CX

anibble: rol    ax,cl           ;roll next AX nibble (4 bits)
         push   ax

         and    al,0Fh          ;( conversion invented by Tim Lopez )
         cmp    al,10           ;0..9  C; -6A 96..9F  A C; +AA 30..39
         sbb    al,69h          ;A..F NC; -69 A1..A6 NA C; +A0 41..46
         das                    ;( NC (no) carry, NA (no) auxiliary )
         stosb                  ;ASCII result

         pop    ax
         dec    ch              ;for all 4 AX nibbles
         jnz    anibble         ;after 4 roll nibbles AX is restored

         pop    cx
         ret

x2c      endp
code     ends

;-----------------------------------------------------------------------
stack    segment para stack 'STACK'

         dw     128 dup (?)     ;stack size in words

stack    ends
         end    main            ;program entry point
